/*
 * Decompiled with CFR 0.152.
 */
package csbase.servlet;

import csbase.servlet.AbstractServlet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InitHtmlServlet
extends AbstractServlet {
    private static final String VERSION_CHECK_PARAMETER = "version_check";
    private static final String PAGE_PARAMETER = "page";
    private static final String JRE_VERSION_PARAMETER = "jre_version";
    private static final String ERROR_PAGE_PARAMETER = "error_page";
    private static final String DESTINATION = "destination_page";

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Hashtable<String, String> parameters = this.createParameterMap(request);
        if (parameters.containsKey(VERSION_CHECK_PARAMETER)) {
            parameters.remove(VERSION_CHECK_PARAMETER);
            String version = this.getServletContext().getInitParameter(JRE_VERSION_PARAMETER);
            String pageURL = this.getServletURL(request);
            String errorPageParameter = parameters.remove(ERROR_PAGE_PARAMETER);
            if (errorPageParameter == null) {
                errorPageParameter = "error.jsp";
            }
            int lastSlash = pageURL.lastIndexOf("/");
            String errorPage = pageURL.substring(0, lastSlash + 1) + errorPageParameter + "?" + JRE_VERSION_PARAMETER + "=" + version;
            Enumeration<String> e = parameters.keys();
            String destinationPage = pageURL;
            String separator = "?";
            while (e.hasMoreElements()) {
                String parameterName = e.nextElement();
                String parameterValue = parameters.get(parameterName);
                destinationPage = destinationPage + separator + parameterName + "=" + parameterValue;
                separator = "&";
            }
            Hashtable<String, String> appletParameters = new Hashtable<String, String>();
            appletParameters.put(DESTINATION, destinationPage);
            appletParameters.put(ERROR_PAGE_PARAMETER, errorPage);
            appletParameters.put(JRE_VERSION_PARAMETER, version);
            String pageContent = this.getPage(request, pageURL + "?page=versioncheck.html", appletParameters);
            pageContent = this.insertScriptParameter(pageContent, errorPage);
            this.printPage(response, pageContent);
        } else {
            String clientAddrParamName = "client_address";
            parameters.put("client_address", request.getRemoteAddr());
            parameters.remove(PAGE_PARAMETER);
            String page = this.getPageParameter(request);
            String pageURL = this.getServletURL(request);
            int lastSlash = pageURL.lastIndexOf("/");
            pageURL = pageURL.substring(0, lastSlash + 1) + page;
            String pageContent = this.getPage(request, pageURL, parameters);
            this.printPage(response, pageContent);
        }
    }

    private void printPage(HttpServletResponse response, String pageContent) throws IOException, ServletException {
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        try {
            out.println(pageContent);
            out.close();
        }
        catch (Exception e) {
            out.println("<html><head>Erro</head><body>");
            out.println("Erro!<br>");
            out.println("Por favor, entre em contato com o suporte do sistema,<br>");
            out.println("e forne\u00e7a a seguinte mensagem:<br>");
            out.println(e.toString());
            out.println("</body></html>");
            out.close();
            throw new ServletException((Throwable)e);
        }
    }

    private Hashtable<String, String> createParameterMap(HttpServletRequest request) {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            parameters.put(name, request.getParameter(name));
            System.out.println(name + ": " + parameters.get(name));
        }
        return parameters;
    }

    private String getPage(HttpServletRequest request, String page, Hashtable<String, String> parameters) throws IOException {
        URL url = new URL(page);
        InputStream is = url.openStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StringBuffer buffer = new StringBuffer();
        String line = null;
        while ((line = br.readLine()) != null) {
            buffer.append(line).append("\n");
        }
        br.close();
        isr.close();
        is.close();
        String result = buffer.toString();
        return this.insertParameters(result, parameters);
    }

    private String getServletURL(HttpServletRequest request) {
        String serverName = request.getServerName();
        String serverPort = Integer.toString(request.getServerPort());
        String requestURI = request.getRequestURI();
        return "http://" + serverName + ":" + serverPort + requestURI;
    }

    private String getPageParameter(HttpServletRequest request) {
        String page = request.getParameter(PAGE_PARAMETER);
        if (page == null) {
            page = "index.html";
        }
        return page;
    }

    private String insertParameters(String page, Hashtable<String, String> parameters) {
        int pos = page.toLowerCase().indexOf("</applet>");
        if (pos == -1) {
            return page;
        }
        StringBuffer buffer = new StringBuffer(page.substring(0, pos));
        Enumeration<String> e = parameters.keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            String value = parameters.get(name);
            buffer.append("<param name=").append(name);
            buffer.append(" value=").append(value).append(">\n");
        }
        buffer.append(page.substring(pos));
        return buffer.toString();
    }

    private String insertScriptParameter(String page, String parameter) {
        int pos = page.toLowerCase().indexOf("</script>");
        if (pos == -1) {
            return page;
        }
        StringBuffer buffer = new StringBuffer(page.substring(0, pos));
        buffer.append("\nparent.location=\"").append(parameter + "\"\n");
        buffer.append(page.substring(pos));
        return buffer.toString();
    }
}

