package csbase.sga.monitor;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import sgaidl.SGA_ALGORITHM_ROOT_DIR;
import sgaidl.SGA_FILE_SEPARATOR;
import sgaidl.SGA_NODE_PLATFORM_ID;
import sgaidl.SGA_PROJECT_ROOT_DIR;
import sgaidl.SGA_SANDBOX_ROOT_DIR;

public class SGAInfo {
  private String defaulValue = "-1";
  public Map<String, String> properties;
  public List<NodeInfo> nodesInfo;

  private SGAInfo() {
    this.nodesInfo = new LinkedList<>();
    this.properties = new HashMap<>();
  }

  public SGAInfo(Properties props) {
    this();
    for (Object key : props.keySet()) {
      this.properties.put((String) key, props.getProperty((String) key));
    }
  }

  public SGAInfo(Map<String, String> properties) {
    this();
    this.properties.putAll(properties);
  }

  public SGAInfo(String pathSeparator, String projectPath, String algorithmPath,
    String sandboxPath) {
    this();
    this.properties.put(SGA_FILE_SEPARATOR.value, pathSeparator);
    this.properties.put(SGA_PROJECT_ROOT_DIR.value, projectPath);
    this.properties.put(SGA_ALGORITHM_ROOT_DIR.value, algorithmPath);
    this.properties.put(SGA_SANDBOX_ROOT_DIR.value, sandboxPath);
  }

  public void addNode(String name, String platform, String cpus, String speed,
    String ram, String swap, String freeRam, String freeSwap, String load1min,
    String load5min, String load15min, String jobs) {
    String plat = platform;
    if (plat == null) {
      plat = properties.get(SGA_NODE_PLATFORM_ID.value);
    }
    NodeInfo nodeInfo =
      new NodeInfo(name, plat, cpus, speed, ram, swap, freeRam, freeSwap,
        load1min, load5min, load15min, jobs);
    nodesInfo.add(nodeInfo);
  }

  //  SGA - Esttica
  //  SGA_FILE_SEPARATOR.value
  //  SGA_PROJECT_ROOT_DIR.value
  //  SGA_ALGORITHM_ROOT_DIR.value
  //  SGA_SANDBOX_ROOT_DIR.value
}
