/**
 * $Id: CommandPersistence.java 169757 2015-11-13 12:26:57Z fpina $
 */
package csbase.sga;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Map;

import csbase.sga.executor.JobData;

/**
 * Camada de persistncia de jobs.
 *
 * @author Tecgraf/PUC-Rio
 */
class CommandPersistence {
  /** Intncia nica */
  private static CommandPersistence instance;
  /** Caminho para o arquivo de persistncia */
  private String persistenceFile;
  /**
   * Mapa com os identificadores de comandos e os dados dos job na camada de
   * execuo de jobs.
   */
  private Map<String, JobData> commands;

  /**
   * Construtor
   *
   * @param persistenceFile caminho para o arquivo de persistncia
   */
  CommandPersistence(String persistenceFile) {
    File file = new File(persistenceFile);
    try {
      file.createNewFile();
    }
    catch (IOException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }

    this.persistenceFile = persistenceFile;
    this.commands = new Hashtable<>();

    read();
  }

  /**
   * Adiciona um comando e grava no arquivo
   *
   * @param commandId identificador do comando
   * @param data dado da camanda de execuo ao associado comando
   */
  protected synchronized void addCommand(String commandId, JobData data) {
    commands.put(commandId, data);
    write();
  }

  /**
   * Adiciona um conjunto de comandos e grava no arquivo
   *
   * @param commands um mapa com os identificadores de comandos os dados
   *        associado a eles
   */
  protected synchronized void addCommands(Map<String, JobData> commands) {
    this.commands = commands;
    write();
  }

  /**
   * Remove um comando.
   *
   * @param commanId identificador do comando
   */
  protected synchronized void removeCommand(String commanId) {
    this.commands.remove(commanId);
    write();
  }

  /**
   * Obtm os comando armazenados
   *
   * @return um mapa com os identificadores de comandos os dados associado a
   *         eles
   */
  protected Map<String, JobData> getCommands() {
    return this.commands;
  }

  /**
   * Grava os comandos e seus dados no arquivo
   */
  private void write() {
    try (FileOutputStream fos = new FileOutputStream(persistenceFile);
      ObjectOutputStream oos =
        new ObjectOutputStream(new BufferedOutputStream(fos))) {
      oos.writeObject(commands);
    }
    catch (FileNotFoundException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    catch (IOException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }

  /**
   * Le os comando e seus dados do arquivo
   */
  private void read() {
    try (FileInputStream fis = new FileInputStream(persistenceFile);
      ObjectInputStream ois = new ObjectInputStream(fis);) {

      commands = (Map<String, JobData>) ois.readObject();
    }
    catch (EOFException e) {

    }
    catch (FileNotFoundException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    catch (IOException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    catch (ClassNotFoundException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }
}
