/**
 * $Id: DefaultJobData.java 177959 2016-12-02 11:56:05Z fpina $
 */
package csbase.sga.executor;

import java.util.Map;

/**
 * Implementao padro da interface JobData. Esta implementao encapsula o
 * identificador do job e o identificador do processo no SO.
 *
 * @author Tecgraf/PUC-Rio
 */
public class DefaultJobData extends AbstractJobData {
  /** UID */
  private static final long serialVersionUID = -9142976023522982409L;
  /** Identificador do job */
  private String jobId;
  /** Identificador do processo no SO */
  private String pid;

  /**
   * Construtor.
   *
   * @param jobId     identificador do job
   * @param execParam os parmetros de execuo do job
   */
  protected DefaultJobData(String jobId, Map<String, String> execParam) {
    super(execParam);
    this.jobId = jobId;
  }

  /**
   * Obtm o identificador do job.
   *
   * @return o identificador do job
   */
  protected String getJobId() {
    return this.jobId;
  }

  /**
   * Obtm o identificador do processo.
   *
   * @return o identificador do processo
   */
  protected String getPID() {
    return this.pid;
  }

  /**
   * Retorna a representao textual dos dados, que  o JobId.
   */
  @Override
  public String toString() {
    return jobId;
  }
}