/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga;

import csbase.sga.executor.JobData;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;

class CommandPersistence {
    private static CommandPersistence instance;
    private String persistenceFileCmds;
    private String persistenceFileParams;
    private Map<String, JobData> commands;
    private Map<String, Map<String, String>> commandsParams;

    CommandPersistence(String persistenceFile) {
        this.persistenceFileCmds = persistenceFile + ".cmds";
        this.persistenceFileParams = persistenceFile + ".params";
        this.commands = new Hashtable<String, JobData>();
        this.commandsParams = new Hashtable<String, Map<String, String>>();
        try {
            File file = new File(this.persistenceFileCmds);
            file.createNewFile();
            file = new File(this.persistenceFileParams);
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.read();
    }

    protected synchronized void addCommand(String commandId, JobData data, Map<String, String> params) {
        this.commands.put(commandId, data);
        this.commandsParams.put(commandId, params);
        this.write();
    }

    protected synchronized void addCommands(Map<String, JobData> commands, Map<String, Map<String, String>> commandsParams) {
        this.commands = commands;
        this.commandsParams = commandsParams;
        this.write();
    }

    protected synchronized void removeCommand(String commandId) {
        this.commands.remove(commandId);
        this.commandsParams.remove(commandId);
        this.write();
    }

    protected Map<String, JobData> getCommands() {
        return Collections.unmodifiableMap(this.commands);
    }

    protected Map<String, Map<String, String>> getCommandsParams() {
        return Collections.unmodifiableMap(this.commandsParams);
    }

    private void write() {
        Throwable throwable;
        ObjectOutputStream oos2;
        Throwable throwable2;
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(this.persistenceFileCmds);
            throwable2 = null;
            try {
                oos2 = new ObjectOutputStream(new BufferedOutputStream(fos));
                throwable = null;
                try {
                    oos2.writeObject(this.commands);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (oos2 != null) {
                        if (throwable != null) {
                            try {
                                oos2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            oos2.close();
                        }
                    }
                }
            }
            catch (Throwable oos2) {
                throwable2 = oos2;
                throw oos2;
            }
            finally {
                if (fos != null) {
                    if (throwable2 != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable oos2) {
                            throwable2.addSuppressed(oos2);
                        }
                    } else {
                        fos.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fos = new FileOutputStream(this.persistenceFileParams);
            throwable2 = null;
            try {
                oos2 = new ObjectOutputStream(new BufferedOutputStream(fos));
                throwable = null;
                try {
                    oos2.writeObject(this.commandsParams);
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (oos2 != null) {
                        if (throwable != null) {
                            try {
                                oos2.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            oos2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                if (fos != null) {
                    if (throwable2 != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable8) {
                            throwable2.addSuppressed(throwable8);
                        }
                    } else {
                        fos.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void read() {
        Throwable throwable;
        ObjectInputStream ois2;
        Throwable throwable2;
        FileInputStream fis;
        try {
            fis = new FileInputStream(this.persistenceFileCmds);
            throwable2 = null;
            try {
                ois2 = new ObjectInputStream(fis);
                throwable = null;
                try {
                    this.commands = (Map)ois2.readObject();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (ois2 != null) {
                        if (throwable != null) {
                            try {
                                ois2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ois2.close();
                        }
                    }
                }
            }
            catch (Throwable ois2) {
                throwable2 = ois2;
                throw ois2;
            }
            finally {
                if (fis != null) {
                    if (throwable2 != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable ois2) {
                            throwable2.addSuppressed(ois2);
                        }
                    } else {
                        fis.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            fis = new FileInputStream(this.persistenceFileParams);
            throwable2 = null;
            try {
                ois2 = new ObjectInputStream(fis);
                throwable = null;
                try {
                    this.commandsParams = (Map)ois2.readObject();
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (ois2 != null) {
                        if (throwable != null) {
                            try {
                                ois2.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            ois2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                if (fis != null) {
                    if (throwable2 != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable8) {
                            throwable2.addSuppressed(throwable8);
                        }
                    } else {
                        fis.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

