/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.ws.rs.core.Response;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.collect.Lists;
import org.glassfish.jersey.server.validation.ValidationError;

public final class ValidationHelper {
    public static List<ValidationError> constraintViolationToValidationErrors(ConstraintViolationException violation) {
        return Lists.transform((List)Lists.newArrayList((Iterable)violation.getConstraintViolations()), (Function)new Function<ConstraintViolation<?>, ValidationError>(){

            public ValidationError apply(ConstraintViolation<?> violation) {
                return new ValidationError(violation.getMessage(), violation.getMessageTemplate(), ValidationHelper.getViolationPath(violation), ValidationHelper.getViolationInvalidValue(violation.getInvalidValue()));
            }
        });
    }

    private static String getViolationInvalidValue(Object invalidValue) {
        if (invalidValue == null) {
            return null;
        }
        if (invalidValue.getClass().isArray()) {
            if (invalidValue instanceof Object[]) {
                return Arrays.toString((Object[])invalidValue);
            }
            if (invalidValue instanceof boolean[]) {
                return Arrays.toString((boolean[])invalidValue);
            }
            if (invalidValue instanceof byte[]) {
                return Arrays.toString((byte[])invalidValue);
            }
            if (invalidValue instanceof char[]) {
                return Arrays.toString((char[])invalidValue);
            }
            if (invalidValue instanceof double[]) {
                return Arrays.toString((double[])invalidValue);
            }
            if (invalidValue instanceof float[]) {
                return Arrays.toString((float[])invalidValue);
            }
            if (invalidValue instanceof int[]) {
                return Arrays.toString((int[])invalidValue);
            }
            if (invalidValue instanceof long[]) {
                return Arrays.toString((long[])invalidValue);
            }
            if (invalidValue instanceof short[]) {
                return Arrays.toString((short[])invalidValue);
            }
        }
        return invalidValue.toString();
    }

    private static String getViolationPath(ConstraintViolation violation) {
        String rootBeanName = violation.getRootBean().getClass().getSimpleName();
        String propertyPath = violation.getPropertyPath().toString();
        return rootBeanName + (!"".equals(propertyPath) ? '.' + propertyPath : "");
    }

    public static Response.Status getResponseStatus(ConstraintViolationException violation) {
        Iterator iterator = violation.getConstraintViolations().iterator();
        if (iterator.hasNext()) {
            for (Path.Node node : ((ConstraintViolation)iterator.next()).getPropertyPath()) {
                ElementKind kind = node.getKind();
                if (!ElementKind.RETURN_VALUE.equals((Object)kind)) continue;
                return Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.Status.BAD_REQUEST;
    }

    private ValidationHelper() {
    }
}

