package csbase.sga.rest;

import java.util.Properties;
import java.util.logging.Logger;

import csbase.server.plugin.service.sgaservice.ISGADaemon;
import csbase.server.plugin.service.sgaservice.SGADaemonException;

import sgaidl.InvalidPathException;
import sgaidl.MissingParameterException;
import sgaidl.Pair;
import sgaidl.PathNotFoundException;
import sgaidl.SGACommand;
import sgaidl.SGAControlAction;
import sgaidl.SGAPath;
import sgaidl.SystemException;

/**
 * An abstract class implementing the ISGADaemon interface 
 * just so we can make the main plugin class implement the required
 * interface without much cruft.
 *
 * This class is derived by both SGARestPlugin and SGARestDaemon,
 * but each of them uses different parts of the ISGADaemon interface.
 * This seems to stem from the fact that historically one plugin
 * represented one daemon, but this is not the case in csbase.sga.rest.
 */
public abstract class AbstractDaemon implements ISGADaemon {

   protected Properties pluginProperties;

   protected Logger logger;

   // Implemented in SGARestPlugin
   @Override
   public boolean start() throws SGADaemonException {
      // TODO
      logger.info("Not implemented: start");
      return true;
   }

   @Override
   public void stop() {
      logger.info("Not implemented: stop");
      // TODO
   }
   
   @Override
   public void setProperties(Properties properties) {
      this.pluginProperties = properties;
   }

   // Implemented in SGARestDaemon
   @Override
   public SGAPath getPath(String path) throws InvalidPathException, PathNotFoundException {
      logger.info("Not implemented: getPath: " + path);
       // TODO
       return null;
   }

   @Override
   public SGAPath[] getPaths(String root) throws InvalidPathException, PathNotFoundException {
      logger.info("Not implemented: getPaths: " + root);
      // TODO not implemented in SGALocal either
      return null;
   }

   /*
   private String print(Pair[] extraParams) {
      StringBuffer sb = new StringBuffer();
      for (int i = 0; i < extraParams.length; i++) {
         if (i > 0) {
            sb.append(", ");
         }
         sb.append(extraParams[i].toString());
      }
      return sb.toString();
   }
   */

   // Implemented in SGARestDaemon
   @Override
   public SGACommand executeCommand(final String commandString, final String commandId, Pair[] extraParams)
   throws SystemException, MissingParameterException {
      logger.info("Not implemented: executeCommand: " + commandString + " id: " + commandId + " extraParams: " + extraParams);
      // TODO
      return null;
   }

   @Override
   public void control(SGAControlAction action) {
      logger.info("Not implemented: control: " + action);
      // TODO
   }

   @Override
   public void setDefaultInfoKeys(String[] keys) {
      logger.info("Not implemented: setDefaultInfoKeys: " + keys);
      //TODO not implemented in SGALocal either
   }

   @Override
   public void setDefaultConfigKeys(String[] keys) {
      logger.info("Not implemented: setDefaultConfigKeys: " + keys);
      //TODO not implemented in SGALocal either
   }

   @Override
   public void ping() {
      logger.info("Not implemented: ping");
      // TODO
   }

}
