package csbase.sga.rest;

import csbase.server.plugin.service.IServiceManager;
import csbase.server.plugin.service.sgaservice.SGADaemonException;

import csbase.sga.rest.RestServer;
import csbase.sga.rest.CSBaseFacade;

import java.util.Properties;
import java.util.logging.Logger;

public class SGARestPlugin extends AbstractDaemon {

   public static RestServer restServer;
   public static CSBaseFacade csbase;

   public SGARestPlugin(IServiceManager serviceManager) {
      this.logger = Logger.getLogger(this.getClass().getName());
      logger.info("SGARest plugin loaded.");
      if (csbase == null) {
         csbase = new CSBaseFacade(serviceManager);
      }
   }

   @Override
   public boolean start() throws SGADaemonException {
      if (restServer == null) {
         String host = pluginProperties.getProperty("host");
         String port = pluginProperties.getProperty("port");
         if (host == null) {
            host = "localhost";
            logger.warning("SGARest host set to '"+host+"' by default.");
         }
         int portNumber = 0;
         try {
            portNumber = Integer.parseInt(port);
         } catch (NumberFormatException e) {
            port = null;
         }
         if (port == null || portNumber < 1024 || portNumber > 65535) {
            portNumber = 40409;
            logger.warning("SGARest port set to "+portNumber+" by default.");
         }
         logger.info("Will start RestServer with host "+host+" port "+portNumber);
         restServer = RestServer.getInstance(host, portNumber);
         boolean ok = false;
         try {
            ok = restServer.start();
         } catch (Exception e) {
            logger.severe("Error starting restserver: " + e);
         }
         if (ok) {
            logger.info("SGARest server started.");
         } else {
            logger.info("SGARest server failed to start.");
         }
      }
      return true;
   }

}
