/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.rest;

import csbase.server.plugin.service.sgaservice.SGADaemonCommand;
import csbase.sga.rest.messages.CommandStatusResponse;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.jackson.JacksonFeature;
import sgaidl.ActionNotSupportedException;
import sgaidl.InvalidActionException;
import sgaidl.InvalidTransitionException;
import sgaidl.JobControlAction;
import sgaidl.Pair;
import sgaidl.RunningCommandInfo;

public class SGARestCommand
extends SGADaemonCommand {
    private final String commandId;
    private final Logger logger;
    private final Client client;
    private Map<String, String> actions;

    public SGARestCommand(String commandId, Map<String, String> actions) {
        this.commandId = commandId;
        this.actions = actions;
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass().getName() + "." + commandId);
        this.client = (Client)ClientBuilder.newClient().register(JacksonFeature.class);
    }

    public void setActions(Map<String, String> actions) {
        this.actions = actions;
    }

    private RunningCommandInfo convertCommandStatus(CommandStatusResponse commandStatus) {
        LinkedList<Pair[]> processData = new LinkedList<Pair[]>();
        for (Map map : commandStatus.processes) {
            LinkedList<Pair> pDic = new LinkedList<Pair>();
            for (String key : map.keySet()) {
                String value = (String)map.get(key);
                if (key.endsWith("_sec")) {
                    try {
                        int intValue = (int)Double.parseDouble(value);
                        value = "" + intValue;
                    }
                    catch (Exception e) {
                        value = "-1";
                    }
                } else if (key.endsWith("_mb") || key.endsWith("_kb")) {
                    try {
                        double e = (int)Double.parseDouble(value);
                    }
                    catch (Exception e) {
                        value = "-1";
                    }
                }
                pDic.add(new Pair("csbase_command_" + key, value));
            }
            processData.add(pDic.toArray(new Pair[0]));
        }
        return new RunningCommandInfo((Pair[][])processData.toArray((T[])new Pair[0][]), new Pair[0]);
    }

    public RunningCommandInfo getRunningCommandInfo() {
        Response response;
        String url = this.actions.get("status");
        if (url == null) {
            this.logger.severe("Error, no 'status' action defined for command " + this.commandId);
        }
        this.logger.info("Will query status for command " + this.commandId + " via " + url);
        try {
            response = this.client.target(url).request(new String[]{"application/json"}).get();
        }
        catch (Exception e) {
            this.logger.severe("Failed querying " + url + " - " + e);
            return null;
        }
        this.logger.info("Queried status for command " + this.commandId + " via " + url);
        int code = response.getStatus();
        if (code != Response.Status.OK.getStatusCode()) {
            return null;
        }
        CommandStatusResponse commandStatus = (CommandStatusResponse)response.readEntity(CommandStatusResponse.class);
        return this.convertCommandStatus(commandStatus);
    }

    public void control(JobControlAction jca, String childJobId) throws InvalidActionException, ActionNotSupportedException, InvalidTransitionException {
        try {
            String action;
            if (jca.equals(JobControlAction.TERMINATE)) {
                action = "terminate";
            } else if (jca.equals(JobControlAction.SUSPEND)) {
                action = "suspend";
            } else if (jca.equals(JobControlAction.RESUME)) {
                action = "resume";
            } else if (jca.equals(JobControlAction.HOLD)) {
                action = "hold";
            } else if (jca.equals(JobControlAction.RELEASE)) {
                action = "release";
            } else {
                throw new Exception("Unknown control action: " + jca);
            }
            String url = this.actions.get(action);
            if (url == null) {
                throw new Exception("SGA didn't tell us URI for: " + action);
            }
            this.logger.info("Sending job control action '" + action + "' via " + url);
            Response response = this.client.target(url).request().get();
            int code = response.getStatus();
            response.close();
            if (code != Response.Status.OK.getStatusCode()) {
                throw new Exception("Job control action " + action + " response: " + code);
            }
            this.logger.info("Job control action " + action + " response: " + code);
        }
        catch (Exception e) {
            this.logger.severe(e.getMessage());
        }
    }
}

