/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.rest.resources;

import csbase.sga.rest.RestServer;
import csbase.sga.rest.SGARestPlugin;
import csbase.sga.rest.messages.CompletionRequest;
import csbase.sga.rest.messages.RegistrationRequest;
import csbase.sga.rest.messages.RegistrationResponse;
import csbase.sga.rest.messages.RegistrationResponseActions;
import csbase.sga.rest.messages.RegistrationResponseError;
import csbase.sga.rest.messages.StatusRequest;
import csbase.sga.rest.messages.parts.Action;
import csbase.sga.rest.messages.parts.HeartbeatAction;
import java.util.HashMap;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import sgaidl.InvalidCommandException;
import sgaidl.InvalidParameterException;
import sgaidl.InvalidSGAException;
import sgaidl.NoPermissionException;
import sgaidl.SGAAlreadyRegisteredException;
import sgaidl.SGANotRegisteredException;

@Path(value="v1/sga")
public class SGA {
    private static final String root = "/v1/sga";

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postIt(@Valid RegistrationRequest registration) {
        RegistrationResponse response;
        boolean ok = true;
        Response.Status code = Response.Status.CREATED;
        String error = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        String sgaName = registration.name;
        properties.put("name", sgaName);
        properties.put("platform", registration.platform);
        properties.put("project_root_dir", registration.project_root_dir);
        properties.put("algorithm_root_dir", registration.algorithm_root_dir);
        if (registration.extra_config != null) {
            properties.putAll(registration.extra_config);
        }
        try {
            ok = SGARestPlugin.csbase.register(registration.name, properties, registration.nodes, registration.actions, registration.persistent_data);
            if (!ok) {
                code = Response.Status.BAD_REQUEST;
                error = "Error registering. CSBase did not provide further diagnostics.";
            }
        }
        catch (InvalidSGAException e) {
            code = Response.Status.BAD_REQUEST;
            error = "Invalid SGA (?)";
        }
        catch (InvalidParameterException e) {
            code = Response.Status.BAD_REQUEST;
            error = "Invalid parameter";
        }
        catch (NoPermissionException e) {
            code = Response.Status.FORBIDDEN;
            error = "No permission";
        }
        catch (SGAAlreadyRegisteredException e) {
            code = Response.Status.FOUND;
            error = "SGA already registered";
            ok = true;
        }
        if (ok) {
            RegistrationResponseActions responseActions = new RegistrationResponseActions();
            responseActions.actions.heartbeat = new HeartbeatAction(SGARestPlugin.csbase.getHeartbeatInterval(sgaName), RestServer.path(root, sgaName + "/heartbeat"));
            responseActions.actions.status = new Action(RestServer.path(root, sgaName + "/status"));
            responseActions.actions.completion = new Action(RestServer.path(root, sgaName + "/completion"));
            response = responseActions;
        } else {
            assert (error != null);
            response = new RegistrationResponseError(error);
        }
        return Response.status((Response.Status)code).entity((Object)response).build();
    }

    @GET
    @Path(value="/{name:[A-Za-z0-9_]+}/heartbeat")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public Response heartbeat(@PathParam(value="name") String sgaName) {
        Response.Status code = Response.Status.OK;
        try {
            boolean ok = SGARestPlugin.csbase.keepAlive(sgaName);
            if (!ok) {
                code = Response.Status.NOT_FOUND;
            }
        }
        catch (InvalidSGAException e) {
            code = Response.Status.BAD_REQUEST;
        }
        catch (NoPermissionException e) {
            code = Response.Status.FORBIDDEN;
        }
        return Response.status((Response.Status)code).build();
    }

    @POST
    @Path(value="/{name:[A-Za-z0-9_]+}/status")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response postIt(@PathParam(value="name") String sgaName, @Valid StatusRequest status) {
        Response.Status code = Response.Status.OK;
        try {
            boolean ok = SGARestPlugin.csbase.updateStatus(sgaName, status.nodes);
            if (!ok) {
                code = Response.Status.BAD_REQUEST;
            }
        }
        catch (InvalidParameterException e) {
            code = Response.Status.BAD_REQUEST;
        }
        catch (NoPermissionException e) {
            code = Response.Status.FORBIDDEN;
        }
        catch (SGANotRegisteredException e) {
            code = Response.Status.UNAUTHORIZED;
        }
        return Response.status((Response.Status)code).build();
    }

    @POST
    @Path(value="/{name:[A-Za-z0-9_]+}/completion")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response postIt(@PathParam(value="name") String sgaName, @Valid CompletionRequest cr) {
        Response.Status code = Response.Status.OK;
        boolean ok = false;
        try {
            ok = SGARestPlugin.csbase.commandCompleted(sgaName, cr.cmd_id, cr.walltime_s, cr.usertime_s, cr.systime_s);
            if (!ok) {
                code = Response.Status.NOT_FOUND;
            }
        }
        catch (InvalidSGAException e) {
            code = Response.Status.BAD_REQUEST;
        }
        catch (NoPermissionException e) {
            code = Response.Status.FORBIDDEN;
        }
        catch (InvalidCommandException e) {
            code = Response.Status.BAD_REQUEST;
        }
        return Response.status((Response.Status)code).build();
    }
}

