/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.rest;

import com.fasterxml.jackson.core.JsonParseException;
import java.net.URI;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.validation.ValidationFeature;

public class RestServer {
    private static RestServer instance = null;
    private HttpServer server;
    protected Logger logger;
    private static String baseUri;

    public static String path(String resource, String suffix) {
        if (suffix.startsWith("/")) {
            suffix = suffix.substring(1);
        }
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        return "/" + resource + "/" + suffix;
    }

    private RestServer(String host, int port) {
        baseUri = "http://" + host + ":" + port;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public static RestServer getInstance(String host, int port) {
        if (instance == null) {
            instance = new RestServer(host, port);
        }
        return instance;
    }

    public boolean start() {
        ClassLoader cl = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        ResourceConfig rc = new ResourceConfig().packages(new String[]{"csbase.sga.rest.resources"}).register(JsonParseExceptionMapper.class).register(ValidationFeature.class).register(JacksonFeature.class).setClassLoader(cl);
        this.logger.fine("Starting RestServer at " + baseUri + " (rc: " + rc + ")");
        try {
            this.server = GrizzlyHttpServerFactory.createHttpServer((URI)URI.create(baseUri), (ResourceConfig)rc);
        }
        catch (Throwable e) {
            StringBuffer sb = new StringBuffer();
            for (StackTraceElement ste : e.getStackTrace()) {
                sb.append(ste.toString());
                sb.append("\n");
            }
            this.logger.info("*** Error starting web server: " + sb.toString());
        }
        if (this.server != null) {
            this.logger.info("RestServer started at " + baseUri);
            return true;
        }
        this.logger.info("RestServer failed to start at " + baseUri);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        HttpServer myServer;
        if (this.server == null) {
            return false;
        }
        HttpServer httpServer = this.server;
        synchronized (httpServer) {
            myServer = this.server;
            this.server = null;
        }
        myServer.shutdown();
        return true;
    }

    @Provider
    static class JsonParseExceptionMapper
    implements ExceptionMapper<JsonParseException> {
        JsonParseExceptionMapper() {
        }

        public Response toResponse(JsonParseException jpe) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid data supplied for request").build();
        }
    }
}

