/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.miop;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.etf.ListenerBase;
import org.jacorb.orb.miop.MIOPProfile;
import org.jacorb.orb.miop.ServerMIOPConnection;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;
import org.omg.GIOP.Version;

public class MIOPListener
extends ListenerBase {
    private Map<Short, Connection> connections = new HashMap<Short, Connection>();

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.profile = new MIOPProfile("225.0.0.1", 10925, "default", 1L, new Version(1, 0), 1, null);
    }

    @Override
    public void destroy() {
        Iterator<Short> i = this.connections.keySet().iterator();
        while (i.hasNext()) {
            this.removeGroupConnection(i.next());
        }
        super.destroy();
    }

    @Override
    public Connection accept() {
        if (this.up != null) {
            throw new BAD_INV_ORDER("Must not call accept() when a Handle has been set");
        }
        Connection result = super.accept();
        if (result != null) {
            MIOPProfile profile = (MIOPProfile)result.get_server_profile();
            this.connections.put(profile.getUIPMCProfile().the_port, result);
        }
        return result;
    }

    @Override
    public void completed_data(Connection connection) {
        throw new NO_IMPLEMENT();
    }

    public void addGroupConnection(MIOPProfile profile) {
        ServerMIOPConnection c = new ServerMIOPConnection();
        try {
            c.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            throw new INTERNAL("ConfigurationException: " + ce.toString());
        }
        c.connect((Profile)profile, 0L);
        this.deliverConnection((Connection)c);
    }

    public void removeGroupConnection(short port) {
        ServerMIOPConnection c = (ServerMIOPConnection)this.connections.remove(new Short(port));
        if (c != null) {
            c.close();
        }
    }

    public boolean haveGroupConnection(short port) {
        return this.connections.containsKey(new Short(port));
    }
}

