/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import net.schmizz.sshj.userauth.password.PrivateKeyFileResource;
import net.schmizz.sshj.userauth.password.PrivateKeyReaderResource;
import net.schmizz.sshj.userauth.password.PrivateKeyStringResource;
import net.schmizz.sshj.userauth.password.Resource;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS8KeyFile
implements FileKeyProvider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected PasswordFinder pwdf;
    protected Resource<?> resource;
    protected KeyPair kp;
    protected KeyType type;
    protected char[] passphrase;

    @Override
    public PrivateKey getPrivate() throws IOException {
        PrivateKey privateKey;
        if (this.kp != null) {
            privateKey = this.kp.getPrivate();
        } else {
            this.kp = this.readKeyPair();
            privateKey = this.kp.getPrivate();
        }
        return privateKey;
    }

    @Override
    public PublicKey getPublic() throws IOException {
        PublicKey publicKey;
        if (this.kp != null) {
            publicKey = this.kp.getPublic();
        } else {
            this.kp = this.readKeyPair();
            publicKey = this.kp.getPublic();
        }
        return publicKey;
    }

    @Override
    public KeyType getType() throws IOException {
        return this.type != null ? this.type : (this.type = KeyType.fromKey(this.getPublic()));
    }

    @Override
    public void init(Reader location) {
        assert (location != null);
        this.resource = new PrivateKeyReaderResource(location);
    }

    @Override
    public void init(Reader location, PasswordFinder pwdf) {
        this.init(location);
        this.pwdf = pwdf;
    }

    @Override
    public void init(File location) {
        assert (location != null);
        this.resource = new PrivateKeyFileResource(location.getAbsoluteFile());
    }

    @Override
    public void init(File location, PasswordFinder pwdf) {
        this.init(location);
        this.pwdf = pwdf;
    }

    @Override
    public void init(String privateKey, String publicKey) {
        assert (privateKey != null);
        assert (publicKey == null);
        this.resource = new PrivateKeyStringResource(privateKey);
    }

    @Override
    public void init(String privateKey, String publicKey, PasswordFinder pwdf) {
        this.init(privateKey, publicKey);
        this.pwdf = pwdf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyPair readKeyPair() throws IOException {
        KeyPair kp = null;
        PEMParser r = null;
        while (true) {
            try {
                r = new PEMParser(this.resource.getReader());
                Object o = r.readObject();
                JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                pemConverter.setProvider("BC");
                if (o instanceof PEMEncryptedKeyPair) {
                    PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)o;
                    JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                    decryptorBuilder.setProvider("BC");
                    try {
                        this.passphrase = this.pwdf == null ? null : this.pwdf.reqPassword(this.resource);
                        kp = pemConverter.getKeyPair(encryptedKeyPair.decryptKeyPair(decryptorBuilder.build(this.passphrase)));
                        break;
                    }
                    finally {
                        PasswordUtils.blankOut(this.passphrase);
                    }
                }
                if (o instanceof PEMKeyPair) {
                    kp = pemConverter.getKeyPair((PEMKeyPair)o);
                    break;
                }
                this.log.debug("Expected PEMEncryptedKeyPair or PEMKeyPair, got: {}", o);
            }
            catch (EncryptionException e) {
                block12: {
                    try {
                        if (this.pwdf == null || !this.pwdf.shouldRetry(this.resource)) break block12;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(new Closeable[]{r});
                        throw throwable;
                    }
                    IOUtils.closeQuietly(new Closeable[]{r});
                    continue;
                }
                throw e;
            }
            break;
        }
        IOUtils.closeQuietly(new Closeable[]{r});
        if (kp == null) {
            throw new IOException("Could not read key pair from: " + this.resource);
        }
        return kp;
    }

    public String toString() {
        return "PKCS8KeyFile{resource=" + this.resource + "}";
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new PKCS8KeyFile();
        }

        @Override
        public String getName() {
            return "PKCS8";
        }
    }
}

