/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobExecutor;
import csbase.sga.executor.JobInfo;
import csbase.sga.executor.JobObserver;
import csbase.sga.ssh.JobStorage;
import csbase.sga.ssh.SGADriver;
import csbase.sga.ssh.SGASSH;
import csbase.sga.ssh.SSHClientPool;
import csbase.sshclient.CommandResult;
import csbase.sshclient.SSHClient;
import csbase.sshclient.SSHClientException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import sgaidl.ActionNotSupportedException;
import sgaidl.InvalidActionException;
import sgaidl.JobControlAction;

public class SSHExecutor
implements JobExecutor {
    private Properties pluginProperties;
    private SGADriver driver;
    private SSHClientPool sshClientPool;
    private JobStorage jobStorage;
    private Logger logger;

    public SSHExecutor(Properties pluginProperties, SGADriver driver, SSHClientPool sshClientPool) {
        this.pluginProperties = pluginProperties;
        String sgaName = pluginProperties.getProperty("csbase_sga_name");
        this.logger = Logger.getLogger(SGASSH.class.getName() + "." + sgaName);
        long jobInfoMaxAge = 60000L;
        if (pluginProperties.containsKey("csbase_process_time_seconds")) {
            jobInfoMaxAge = Long.parseLong(pluginProperties.getProperty("csbase_process_time_seconds")) * 1000L;
        }
        this.jobStorage = new JobStorage(jobInfoMaxAge);
        this.driver = driver;
        this.sshClientPool = sshClientPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobData executeJob(String jobCommand, Map<String, String> extraParams, JobObserver observer) {
        JobData data = null;
        SSHClient client = null;
        try {
            long startTime = System.currentTimeMillis();
            client = this.sshClientPool.retrieveSSHClient();
            this.logger.fine("Time took to create a SSH Client: " + (System.currentTimeMillis() - startTime) + " ms");
            String command = this.driver.buildSubmitJobCommand(jobCommand, extraParams);
            this.logger.fine("Job's command line: " + command);
            CommandResult result = client.execute(command);
            if (result.getStatus() > 0) {
                this.logger.log(Level.WARNING, "Job execution return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                JobData jobData = null;
                return jobData;
            }
            this.logger.fine("Job execution return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
            data = this.driver.parseJobSubmissionOutput(result.getOutput());
            this.logger.fine("Job's JobData: " + data);
        }
        catch (SSHClientException | IOException e) {
            this.logger.log(Level.SEVERE, "Erro submitting job", e);
            if (client != null) {
                client.disconnect();
            }
        }
        finally {
            if (client != null) {
                this.sshClientPool.returnSSHClient(client);
            }
        }
        if (data == null) {
            this.logger.log(Level.SEVERE, "Cannot parse job submission output");
        } else {
            this.jobStorage.addJob(data, observer);
        }
        return data;
    }

    public boolean recoveryJob(JobData data, JobObserver observer) {
        try {
            this.updateJobsInfo();
        }
        catch (SSHClientException | IOException e) {
            this.logger.log(Level.WARNING, "Erro recovering job", e);
        }
        return this.jobStorage.addObserver(data, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controlJob(JobData data, String child, JobControlAction action) throws InvalidActionException, ActionNotSupportedException {
        SSHClient client = null;
        try {
            client = this.sshClientPool.retrieveSSHClient();
            String controlCommand = this.driver.buildKillJobCommand(data);
            this.logger.fine("Job's control command line: " + controlCommand);
            CommandResult result = client.execute(controlCommand);
            if (result.getStatus() > 0) {
                this.logger.log(Level.WARNING, "Job control return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                return;
            }
            this.logger.fine("Job control return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
        }
        catch (SSHClientException | IOException e) {
            this.logger.log(Level.SEVERE, "Erro controlling job", e);
            if (client != null) {
                client.disconnect();
            }
        }
        finally {
            if (client != null) {
                this.sshClientPool.returnSSHClient(client);
            }
        }
    }

    public JobInfo getJobInfo(JobData data) {
        try {
            this.updateJobsInfo();
        }
        catch (SSHClientException | IOException e) {
            this.logger.log(Level.SEVERE, "Erro updating job info", e);
        }
        return this.jobStorage.getJobInfo(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJobsInfo() throws SSHClientException, IOException {
        if (!this.jobStorage.needsUpdate()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        SSHClient client = null;
        try {
            client = this.sshClientPool.retrieveSSHClient();
            this.logger.fine("Time took to create a SSH Client: " + (System.currentTimeMillis() - startTime) + " ms");
            if (this.driver.buildCheckAllJobsCommand() != null) {
                String updateCommand = this.driver.buildCheckAllJobsCommand();
                this.logger.fine("Job's update command line: " + updateCommand);
                CommandResult result = client.execute(updateCommand);
                if (result.getStatus() > 0) {
                    this.logger.log(Level.WARNING, "Update all jobs info return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                    return;
                }
                this.logger.fine("Update all jobs info return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                this.jobStorage.updateJobs(this.driver.parseCheckAllJobsOutput(result.getOutput()));
            } else {
                HashMap<JobData, JobInfo> newJobsInfo = new HashMap<JobData, JobInfo>();
                for (JobData d : this.jobStorage.getJobs()) {
                    String updateCommand = this.driver.buildCheckJobCommand(d);
                    this.logger.fine("Job's update command line: " + updateCommand);
                    CommandResult result = client.execute(updateCommand);
                    if (result.getStatus() > 0) {
                        this.logger.log(Level.WARNING, "Update job info return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                        return;
                    }
                    this.logger.fine("Update job info return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                    newJobsInfo.putAll(this.driver.parseCheckJobOutput(result.getOutput()));
                }
                this.jobStorage.updateJobs(newJobsInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (client != null) {
                client.disconnect();
            }
        }
        finally {
            if (client != null) {
                this.sshClientPool.returnSSHClient(client);
            }
        }
        this.logger.fine("Time took to update job info: " + (System.currentTimeMillis() - startTime) + " ms");
    }
}

