/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh;

import csbase.sga.monitor.EnvironmentMonitor;
import csbase.sga.monitor.SGAInfo;
import csbase.sga.ssh.SGADriver;
import csbase.sga.ssh.SGASSH;
import csbase.sga.ssh.SSHClientPool;
import csbase.sshclient.CommandResult;
import csbase.sshclient.SSHClient;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SSHMonitor
implements EnvironmentMonitor {
    private final Properties pluginProperties;
    private final SGADriver driver;
    private SSHClientPool sshClientPool;
    private SGAInfo sgaInfo;
    private Logger logger;
    private long lastJobInfoUpdate = 0L;
    private long checkEnvironmentInterval = 20000L;

    public SSHMonitor(Properties pluginProperties, SGADriver driver, SSHClientPool sshClientPool) {
        this.pluginProperties = pluginProperties;
        if (pluginProperties.containsKey("csbase_machine_time_seconds")) {
            this.checkEnvironmentInterval = Long.parseLong(pluginProperties.getProperty("csbase_machine_time_seconds")) * 1000L;
        }
        this.driver = driver;
        this.sshClientPool = sshClientPool;
        this.sgaInfo = new SGAInfo(this.pluginProperties);
        String sgaName = pluginProperties.getProperty("csbase_sga_name");
        this.logger = Logger.getLogger(SGASSH.class.getName() + "." + sgaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        boolean alive = true;
        SSHClient client = null;
        try {
            client = this.sshClientPool.retrieveSSHClient();
            client.execute("ls /");
        }
        catch (Exception e) {
            alive = false;
            this.logger.log(Level.SEVERE, "Erro connection to remote host", e);
            if (client != null) {
                client.disconnect();
            }
        }
        finally {
            if (client != null) {
                this.sshClientPool.returnSSHClient(client);
            }
        }
        return alive;
    }

    public synchronized SGAInfo getSGAInfo() {
        this.updateSGAInfo();
        return this.sgaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSGAInfo() {
        if (System.currentTimeMillis() - this.lastJobInfoUpdate <= this.checkEnvironmentInterval) {
            return;
        }
        long startTime = System.currentTimeMillis();
        SSHClient client = null;
        try {
            client = this.sshClientPool.retrieveSSHClient();
            this.logger.fine("Time took to create a SSH Client: " + (System.currentTimeMillis() - startTime) + " ms");
            String command = this.driver.buildCheckEnvironmentCommand();
            this.logger.fine("Check environment command line: " + command);
            CommandResult result = client.execute(command);
            if (result.getStatus() > 0) {
                this.logger.log(Level.WARNING, "Check environment return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                return;
            }
            this.logger.fine("Check environment return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
            this.sgaInfo = this.driver.parseCheckEnvironmentOutput(result.getOutput());
            this.lastJobInfoUpdate = System.currentTimeMillis();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Erro checking the environment", e);
            if (client != null) {
                client.disconnect();
            }
        }
        finally {
            if (client != null) {
                this.sshClientPool.returnSSHClient(client);
            }
        }
        this.logger.fine("Time took to update environment info: " + (System.currentTimeMillis() - startTime) + " ms");
    }
}

