/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga;

import csbase.sga.executor.JobData;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Map;

class CommandPersistence {
    private static CommandPersistence instance;
    private String persistenceFile;
    private Map<String, JobData> commands;

    CommandPersistence(String persistenceFile) {
        File file = new File(persistenceFile);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.persistenceFile = persistenceFile;
        this.commands = new Hashtable<String, JobData>();
        this.read();
    }

    protected synchronized void addCommand(String commandId, JobData data) {
        this.commands.put(commandId, data);
        this.write();
    }

    protected synchronized void addCommands(Map<String, JobData> commands) {
        this.commands = commands;
        this.write();
    }

    protected synchronized void removeCommand(String commanId) {
        this.commands.remove(commanId);
        this.write();
    }

    protected Map<String, JobData> getCommands() {
        return this.commands;
    }

    private void write() {
        try (FileOutputStream fos = new FileOutputStream(this.persistenceFile);
             ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(fos));){
            oos.writeObject(this.commands);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void read() {
        try (FileInputStream fis = new FileInputStream(this.persistenceFile);
             ObjectInputStream ois = new ObjectInputStream(fis);){
            this.commands = (Map)ois.readObject();
        }
        catch (EOFException e) {
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

