/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Dump {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("usage: java Dump <files>");
            System.exit(0);
        }
        for (int i = 0; i < args.length; ++i) {
            Dump.dump(args[i]);
        }
    }

    private static void dump(String fileName) {
        System.out.println("---------------------------");
        System.out.println(fileName);
        Object obj = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new DataInputStream(new BufferedInputStream(new FileInputStream(fileName))));
            obj = in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println("read error: " + e);
            return;
        }
        if (obj instanceof Collection) {
            Dump.dumpObject((Collection)obj);
        } else if (obj instanceof Map) {
            Dump.dumpObject("", (Map)obj);
        } else if (obj instanceof Object[]) {
            Dump.dumpObject((Object[])obj);
        } else {
            System.out.println(obj);
        }
    }

    private static void dumpObject(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            System.out.print(i.next());
            if (!i.hasNext()) continue;
            System.out.print(",");
        }
        System.out.println("");
    }

    private static void dumpObject(String head, Map m) {
        Set s = m.entrySet();
        for (Map.Entry e : s) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (v instanceof Collection) {
                System.out.print(head + k + " - ");
                Dump.dumpObject((Collection)v);
                continue;
            }
            if (v instanceof Object[]) {
                System.out.print(head + k + " - ");
                Dump.dumpObject((Object[])v);
                continue;
            }
            if (v instanceof Map) {
                System.out.println(head + k + " - <follows>");
                Dump.dumpObject("  " + head, (Map)v);
                continue;
            }
            System.out.println(head + k + " - " + v);
        }
    }

    private static void dumpObject(Object[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            if (i >= a.length - 1) continue;
            System.out.print(",");
        }
        System.out.println("");
    }
}

