package csbase.util.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * {@link InvocationHandler} simplesmente invoca os mtodos em um determinado
 * objeto.
 * 
 * @author Tecgraf
 */
public class Invoker implements InvocationHandler {

  /**
   * Objeto para o qual as chamadas sero delegadas.
   */
  private final Object obj;

  /**
   * Construtor.
   * 
   * @param obj Objeto do qual os mtodos sero invocados. Ele deve implementar
   *        as mesmas interfaces do proxy criado.
   */
  public Invoker(Object obj) {
    this.obj = obj;
  }

  /**
   * Invoca o mtodo do objeto passado no construtor, fazendo: {@code
   * method.invoke(obj, args);}.
   */
  @Override
  public Object invoke(Object proxy, Method method, Object[] args)
    throws Throwable {
    try {
      return method.invoke(obj, args);
    }
    catch (InvocationTargetException e) {
      throw e.getCause();
    }
  }
}
