package csbase.util;

/**
 * Interface de fbrica de objetos. 
 *
 * @param <O> tipo do objeto criado. 
 * @param <A> tipo do objeto que serve de argumento para a fbrica.
 *  
 * @author Tecgraf
 */
public interface IFactory<O, A> {
  /**
   * Cria um objeto do tipo O.
   * 
   * @param arg argumento utilizado pela fbrica para definir que objeto criar. 
   * 
   * @return retorna um novo objeto.
   */
  O create(A arg);
}
