package csbase.util.messages;

import csbase.util.data.dispatcher.AbstractDispatcher;

/**
 * Despacha {@link Message mensagens} para {@link IMessageListener ouvinte de
 * mensagens}.
 * 
 * @author Tecgraf
 */
public class MessageListenerDispatcher extends
  AbstractDispatcher<IMessageListener, Message> {

  /**
   * <p>
   * Despacha {@link Message mensagens} para {@link IMessageListener ouvinte de
   * mensagens}.
   * </p>
   * {@inheritDoc}
   */
  @Override
  protected void dispatch(IMessageListener listener, Message... messages)
    throws Exception {
    listener.onMessagesReceived(messages);
  }
}
