/*
 * Decompiled with CFR 0.152.
 */
package validations;

import csbase.server.services.serverservice.ServerService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import tecgraf.javautils.core.io.FileUtils;
import validations.AbstractValidation;
import validations.ValidationException;
import validations.util.ValidatorUtils;

public class TrustedServer2ServerInfoValidation
extends AbstractValidation {
    private static final String PERSISTENCY_DIR_PROPERTY = "Persistency.newDirectory";
    private static final String NEW_SERVER_REPOSITORY_PROPERTY = "ServerService.serverRepositoryName";
    private static final String OLD_SERVER_REPOSITORY_PROPERTY = "ServerService.oldServerRepositoryName";
    private static final String NULL_PROPERTY_VALUE = "NULL";
    private File backupDir;
    private String persistencyDirPath;
    private File oldServersRepositoryFile;
    private File newServersRepositoryFile;
    private Action action;
    private String warning;

    @Override
    protected boolean runsOnlyOnce() {
        return this.action != Action.TERMINATE;
    }

    @Override
    protected boolean init() {
        this.persistencyDirPath = this.getMandatorySystemProperty(PERSISTENCY_DIR_PROPERTY);
        if (this.persistencyDirPath == null) {
            return false;
        }
        String oldRepPath = this.getSystemProperty(OLD_SERVER_REPOSITORY_PROPERTY);
        if (null == oldRepPath) {
            this.action = Action.TERMINATE;
            this.warning = String.format("CONSIDEROU-SE, DEVIDO A AUS\u00caNCIA DA PROPRIEDADE %s, QUE O SERVI\u00c7O DE SERVIDORES - %s - N\u00c3O EST\u00c1 OU N\u00c3O ESTAVA SENDO UTILIZADO.", OLD_SERVER_REPOSITORY_PROPERTY, ServerService.class.getSimpleName());
            return true;
        }
        if ((oldRepPath = oldRepPath.trim()).equalsIgnoreCase(NULL_PROPERTY_VALUE)) {
            this.action = Action.VALIDATE_OK;
            return true;
        }
        this.oldServersRepositoryFile = new File(this.persistencyDirPath + File.separator + oldRepPath);
        String newRepPath = this.getMandatorySystemProperty(NEW_SERVER_REPOSITORY_PROPERTY);
        if (null == newRepPath) {
            return false;
        }
        if ((newRepPath = newRepPath.trim()).equalsIgnoreCase(NULL_PROPERTY_VALUE)) {
            this.action = Action.REMOVE_OLD_REPOSITORY;
        } else {
            this.newServersRepositoryFile = new File(this.persistencyDirPath + File.separator + newRepPath);
            this.action = Action.CREATE_NEW_REPOSITORY;
        }
        this.backupDir = new File(this.getTempDirPath() + File.separator + this.getClass().getSimpleName());
        return true;
    }

    @Override
    protected boolean validate() throws ValidationException {
        if (this.action == Action.VALIDATE_OK || this.action == Action.TERMINATE) {
            return true;
        }
        if (!this.oldServersRepositoryFile.exists()) {
            String errmsg = "Erro obtendo o antigo reposit\u00f3rio do servi\u00e7o de servidores.\nO arquivo '%s' n\u00e3o foi encontrado.";
            throw new ValidationException(String.format(errmsg, this.oldServersRepositoryFile.getAbsolutePath()));
        }
        return false;
    }

    @Override
    protected String getStartMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Criando um novo reposit\u00f3rio de servidores apontado pela propriedade ").append(NEW_SERVER_REPOSITORY_PROPERTY).append(". O conte\u00fado deste reposit\u00f3rio ser\u00e1 copiado do reposit\u00f3rio apontado pela propriedade ").append(OLD_SERVER_REPOSITORY_PROPERTY).append(", por\u00e9m com o elemento <servidores_confiaveis> renomeado para <servidores>");
        return sb.toString();
    }

    @Override
    protected void getSpecificFailureMessage(AbstractValidation.Status status, List<String> errors) {
        switch (status) {
            case VALIDATION_FAILED: {
                errors.add("*** O REPOSIT\u00d3RIO DE SERVIDORES AINDA N\u00c3O FOI ALTERADO.");
                break;
            }
            case PATCH_FAILED: {
                errors.add("*** OCORREU UM ERRO AO TENTAR ALTERAR O REPOSIT\u00d3RIO DE SERVIDORES.");
                break;
            }
            case INIT_FAILED: {
                errors.add("*** FALHA NA INICIALIZA\u00c7\u00c3O");
                break;
            }
            default: {
                errors.add("ESTADO INV\u00c1LIDO: " + status.toString());
            }
        }
    }

    @Override
    protected String getSuccessMessage(AbstractValidation.Status status) {
        String className = this.getClass().getSimpleName();
        switch (status) {
            case VALIDATION_OK: {
                switch (this.action) {
                    case TERMINATE: {
                        if (this.warning != null) {
                            String fmt = "O VALIDADOR %s FOI INTERROMPIDO. %s";
                            return String.format("O VALIDADOR %s FOI INTERROMPIDO. %s", className, this.warning);
                        }
                        String fmt = "O VALIDADOR %s FOI INTERROMPIDO (SEM MOTIVO).";
                        return String.format("O VALIDADOR %s FOI INTERROMPIDO (SEM MOTIVO).", className);
                    }
                    case VALIDATE_OK: {
                        return "O REPOSIT\u00d3RIO DE SERVIDORES J\u00c1 EST\u00c1 ALTERADO.";
                    }
                }
                return "O SISTEMA FOI CONSIDERADO V\u00c1LIDO, POR\u00c9M O VALIDADOR EST\u00c1 EM UM ESTADO INCONSISTENTE " + this.action.name() + ".";
            }
            case PATCH_OK: {
                return "*** O REPOSIT\u00d3RIO DE SERVIDORES FOI ALTERADO COM SUCESSO.";
            }
        }
        return "ESTADO INV\u00c1LIDO: " + status.toString();
    }

    @Override
    protected boolean backupData() {
        File bkpRepository;
        if (!this.backupDir.exists() && !this.backupDir.mkdirs()) {
            this.logger.severe("Erro criando diret\u00f3rio de backup '" + this.backupDir.getAbsolutePath() + "'");
            return false;
        }
        if (this.oldServersRepositoryFile != null && this.oldServersRepositoryFile.exists() && !ValidatorUtils.copyFile(this.oldServersRepositoryFile, bkpRepository = new File(this.backupDir, this.oldServersRepositoryFile.getName()), this.logger, true)) {
            this.logger.severe(String.format("Erro salvando o backup do arquivo '%s' no diret\u00f3rio '%s'.", this.oldServersRepositoryFile.getAbsolutePath(), this.backupDir.getAbsolutePath()));
            return false;
        }
        return true;
    }

    @Override
    protected boolean restoreBackup() {
        File bkpRepository;
        if (!this.backupDir.exists()) {
            this.logger.severe("Erro, o diret\u00f3rio de backup '" + this.backupDir.getAbsolutePath() + "' n\u00e3o foi encontrado.");
            return false;
        }
        if (this.oldServersRepositoryFile != null && this.oldServersRepositoryFile.exists() && !ValidatorUtils.copyFile(bkpRepository = new File(this.backupDir, this.oldServersRepositoryFile.getName()), this.oldServersRepositoryFile, this.logger, true)) {
            this.logger.severe(String.format("Erro restaurando arquivo '%s' para o diret\u00f3rio '%s'", bkpRepository.getAbsolutePath(), this.oldServersRepositoryFile.getParent()));
            return false;
        }
        FileUtils.delete((File)this.backupDir);
        return true;
    }

    @Override
    protected boolean applyPatch() {
        switch (this.action) {
            case CREATE_NEW_REPOSITORY: {
                return this.createNewRepositoryFile();
            }
            case REMOVE_OLD_REPOSITORY: {
                return this.oldServersRepositoryFile.delete();
            }
        }
        this.logger.severe(String.format("Erro, a\u00e7\u00e3o %s n\u00e3o implementada.", this.action.name()));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createNewRepositoryFile() {
        boolean sameFile = this.oldServersRepositoryFile.getPath().equals(this.newServersRepositoryFile.getPath());
        if (sameFile) {
            String tmpPrefix = this.oldServersRepositoryFile.getName() + ".";
            String tmpSuffix = ".tmp";
            File tmpDir = this.oldServersRepositoryFile.getParentFile();
            try {
                this.newServersRepositoryFile = File.createTempFile(tmpPrefix, tmpSuffix, tmpDir);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            this.newServersRepositoryFile.deleteOnExit();
        }
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            in = new BufferedReader(new FileReader(this.oldServersRepositoryFile));
            out = new BufferedWriter(new FileWriter(this.newServersRepositoryFile));
            String line = in.readLine();
            while (line != null) {
                out.write(line.replaceAll("(</?)servidores_confiaveis>", "$1servidores>"));
                out.newLine();
                line = in.readLine();
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    this.logger.exception("Erro tentando fechar o arquivo '" + this.oldServersRepositoryFile.getAbsolutePath() + "'", e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    this.logger.exception("Erro tentando fechar o arquivo '" + this.newServersRepositoryFile.getAbsolutePath() + "'", e);
                }
            }
        }
        if (sameFile) {
            return this.newServersRepositoryFile.renameTo(this.oldServersRepositoryFile);
        }
        if (!this.oldServersRepositoryFile.delete()) {
            this.logger.warning(String.format("Erro removendo o antigo reposit\u00f3rio representado pelo arquivo '%s'.", this.oldServersRepositoryFile.getAbsolutePath()));
        }
        return true;
    }

    @Override
    protected void finish() {
    }

    private static enum Action {
        REMOVE_OLD_REPOSITORY,
        CREATE_NEW_REPOSITORY,
        VALIDATE_OK,
        TERMINATE;

    }
}

