/*
 * Decompiled with CFR 0.152.
 */
package validations;

import csbase.logic.CommonProjectInfo;
import csbase.util.FileSystemUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import tecgraf.javautils.core.lng.LNG;
import validations.AbstractValidation;
import validations.ValidationException;
import validations.util.ValidatorUtils;

public class PrjInfoValidation
extends AbstractValidation {
    private static final String CONTROL_FILE_SUFFIX = ".csbase_project_info";
    private List<File> allFiles = new ArrayList<File>();
    private Loader loaderV0 = new Loader();
    private Loader loaderV1 = new Loader();

    @Override
    protected boolean init() {
        return true;
    }

    @Override
    protected String getStartMessage() {
        return "Convertendo arquivos de controle dos projetos.";
    }

    @Override
    protected boolean runsOnlyOnce() {
        return true;
    }

    @Override
    protected void getSpecificFailureMessage(AbstractValidation.Status inputStatus, List<String> errors) {
        switch (inputStatus) {
            case PATCH_FAILED: {
                errors.add(LNG.get((String)"validations.ControlFileConversionError"));
                break;
            }
            default: {
                errors.add(LNG.get((String)"validations.InvalidStateLower") + inputStatus.toString());
            }
        }
    }

    @Override
    protected String getSuccessMessage(AbstractValidation.Status inputStatus) {
        switch (inputStatus) {
            case VALIDATION_OK: {
                return LNG.get((String)"validations.NoConversions");
            }
            case PATCH_OK: {
                return LNG.get((String)"validations.InfoConverted");
            }
        }
        return LNG.get((String)"validations.InvalidStateLower") + inputStatus.toString();
    }

    @Override
    protected boolean validate() throws ValidationException {
        this.findFiles();
        return this.allFiles.size() == 0;
    }

    private void findFiles() {
        File baseProjectDir = this.getProjectDir();
        if (baseProjectDir == null) {
            return;
        }
        File[] usersProjects = FileSystemUtils.getSubDirs((File)baseProjectDir);
        if (usersProjects == null || usersProjects.length == 0) {
            String path = baseProjectDir.getAbsolutePath();
            this.logger.fine(LNG.get((String)"validations.NothingToConvert") + path);
            return;
        }
        for (File userPrj : usersProjects) {
            File[] cfgFiles = this.getProjectControlFilesForUser(userPrj);
            if (cfgFiles.length == 0) {
                String path = userPrj.getAbsolutePath();
                this.logger.fine(LNG.get((String)"validations.NoProjectToConvert") + path);
                continue;
            }
            for (File cfgFile : cfgFiles) {
                this.allFiles.add(cfgFile);
            }
        }
    }

    @Override
    protected boolean backupData() {
        try {
            for (File file : this.allFiles) {
                File projectFile = file.getParentFile();
                File userPrjsFile = projectFile.getParentFile();
                File targetDir = new File(this.getBackupDirPath());
                targetDir = new File(targetDir, projectFile.getName());
                if (!(targetDir = new File(targetDir, userPrjsFile.getName())).exists()) {
                    targetDir.mkdirs();
                }
                ValidatorUtils.copyFile(file, targetDir, this.logger, false);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, LNG.get((String)"validations.BackupError"), e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean restoreBackup() {
        try {
            for (File file : this.allFiles) {
                File projectFile = file.getParentFile();
                File userPrjsFile = projectFile.getParentFile();
                File sourceFile = new File(this.getBackupDirPath());
                sourceFile = new File(sourceFile, projectFile.getName());
                sourceFile = new File(sourceFile, userPrjsFile.getName());
                sourceFile = new File(sourceFile, file.getName());
                ValidatorUtils.copyFile(sourceFile, file, this.logger, false);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, LNG.get((String)"validations.RestoreError"), e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean applyPatch() {
        int nProjs = 0;
        File baseProjectDir = this.getProjectDir();
        File[] usersProjects = FileSystemUtils.getSubDirs((File)baseProjectDir);
        if (usersProjects == null || usersProjects.length == 0) {
            String path = baseProjectDir.getAbsolutePath();
            this.logger.fine(LNG.get((String)"validations.NothingToConvert") + path);
            return true;
        }
        for (File userPrj : usersProjects) {
            this.logger.fine(LNG.get((String)"validations.ConvertingProjects") + userPrj.getName());
            nProjs = this.patchUserDir(userPrj, nProjs);
        }
        this.logger.toConsole(MessageFormat.format(LNG.get((String)"validations.TotalAnalyzedProjects"), nProjs));
        return true;
    }

    private int patchUserDir(File userDir, int index) {
        int i = index;
        File[] cfgFiles = this.getProjectControlFilesForUser(userDir);
        if (cfgFiles.length == 0) {
            String path = userDir.getAbsolutePath();
            this.logger.fine(LNG.get((String)"validations.NoProjectToConvert") + path);
            return i;
        }
        for (File cfgFile : cfgFiles) {
            this.patchFile(cfgFile);
            if (++i % 100 != 0) continue;
            this.logger.toConsole(LNG.get((String)"validations.NumAnalyzedProjects"));
        }
        return i;
    }

    private File[] getProjectControlFilesForUser(File userDir) {
        File[] cfgFiles = userDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                boolean isFile = pathname.isFile();
                String name = pathname.getName();
                return isFile && name.endsWith(PrjInfoValidation.CONTROL_FILE_SUFFIX);
            }
        });
        return cfgFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void patchFile(File cfgFile) {
        Method m;
        Class<?> c;
        String cfgPath = cfgFile.getAbsolutePath();
        try {
            c = this.loaderV0.getCPIClass("/validations/resources/CommonProjectInfo.v0.class");
            m = c.getDeclaredMethod("convert", File.class);
            m.invoke(null, cfgFile);
        }
        catch (Throwable e) {
            ObjectInputStream ois = null;
            try {
                FileInputStream fis = new FileInputStream(cfgFile);
                ois = new ObjectInputStream(fis);
                Object object = ois.readObject();
                ois.close();
                if (object instanceof CommonProjectInfo) {
                    this.logger.log(Level.FINE, LNG.get((String)"validations.ConversionNotNeeded") + cfgPath);
                    return;
                }
                this.logger.log(Level.SEVERE, MessageFormat.format(LNG.get((String)"validations.ConversionV0NotAppliedAt"), object.getClass(), cfgPath));
                return;
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, LNG.get((String)"validations.ConversionV0NotApplied") + cfgPath, t);
                return;
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ioe) {
                        this.logger.log(Level.SEVERE, LNG.get((String)"validations.StreamCloseError") + cfgPath);
                    }
                }
            }
        }
        try {
            c = this.loaderV1.getCPIClass("/validations/resources/CommonProjectInfo.v1.class");
            m = c.getDeclaredMethod("convert", File.class);
            m.invoke(null, cfgFile);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, LNG.get((String)"validations.V1Fail") + cfgPath, e);
        }
    }

    @Override
    protected void finish() {
    }

    private class Loader
    extends ClassLoader {
        private Map<String, Class<?>> cache = new HashMap();

        private Loader() {
        }

        Class<?> getCPIClass(String filename) throws Exception {
            int b;
            Class<?> c = this.cache.get(filename);
            if (c != null) {
                return c;
            }
            InputStream is = PrjInfoValidation.this.getClass().getResourceAsStream(filename);
            if (is == null) {
                throw new RuntimeException(String.format(LNG.get((String)"validations.ResourceNotfound"), filename));
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((b = is.read()) != -1) {
                os.write(b);
            }
            byte[] b2 = os.toByteArray();
            c = this.defineClass("csbase.logic.CommonProjectInfo", b2, 0, b2.length);
            this.cache.put(filename, c);
            return c;
        }
    }
}

