package Requests.Jobs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JobInfo {
	private String jobId = null;

	private String sessionId = null;

	public enum SubmitedByEnum {
		REST_SERVICE("REST Service"),
		RMI_SERVICE("RMI Service");
		private String value;
		SubmitedByEnum(String value) {
			this.value = value;
		}
		@Override
		public String toString() {
			return String.valueOf(value);
		}
	}

	public enum StatusType {
		SCHEDULED("SCHEDULED"),
		INIT("INIT"),
		UPLOADING("UPLOADING"),
		QUEUED("QUEUED"),
		EXECUTING("EXECUTING"),
		DOWNLOADING("DOWNLOADING"),
		FINISHED("FINISHED"),
		UNKNOWN("UNKNOWN");
		private String value;
		StatusType(String value) {
			this.value = value;
		}
		@Override
		public String toString() {
			return String.valueOf(value);
		}
	}

	private SubmitedByEnum submitedBy = null;
	private String projectId = null;
	private String algorithmId = null;
	private String algorithmVersion = null;
	private String jobOwner = null;
	private Boolean automaticallyMachineSelection = null;
	private String submissionMachine = null;
	private String submissionTime = null;
	private String executionMachine = null;
	private String endTime = null;
	private Integer numberOfAttempts = null;
	private String description = null;
	private Integer priority = null;
	private StatusType state = null;
	private Integer exitCode = null;

	public enum ExitStatusEnum {
		UNKNOWN("unknown"),
		SUCCESS("success"),
		EXECUTION_ERROR("execution_error"),
		JOB_IDENTIFIER_NOT_FOUND("job_identifier_not_found"),
		UNEXPECTED_MACHINE_ERROR("unexpected_machine_error"),
		PROJECT_NOT_FOUND("project_not_found"),
		FAILED_SETUP_EXECUTION_ENVIRONMENT("failed_setup_execution_environment"),
		NO_PERMISSION("no_permission"),
		NO_MACHINE_AVAILABLE("no_machine_available"),
		KILLED("killed"),
		LOST("lost"),
		UNDEFINED("undefined");
		private String value;
		ExitStatusEnum(String value) {
			this.value = value;
		}
		@Override
		public String toString() {
			return String.valueOf(value);
		}
	}

	private ExitStatusEnum exitStatus = null;
	private Double cpuTime = null;
	private Integer wallclockTime = null;
	private Double ramMemory = null;
	private String progressInfo = null;
	private List<StatusChangeHistory> statusHistory = new ArrayList<StatusChangeHistory>();
	private String lastModifiedTime = null;

	public JobInfo jobId(String jobId) {
		this.jobId = jobId;
		return this;
	}

	public String getJobId() {
		return jobId;
	}

	public void setJobId(String jobId) {
		this.jobId = jobId;
	}

	public JobInfo sessionId(String sessionId) {
		this.sessionId = sessionId;
		return this;
	}

	public String getSessionId() {
		return sessionId;
	}

	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	public JobInfo submitedBy(SubmitedByEnum submitedBy) {
		this.submitedBy = submitedBy;
		return this;
	}

	public SubmitedByEnum getSubmitedBy() {
		return submitedBy;
	}

	public void setSubmitedBy(SubmitedByEnum submitedBy) {
		this.submitedBy = submitedBy;
	}

	public JobInfo projectId(String projectId) {
		this.projectId = projectId;
		return this;
	}

	public String getProjectId() {
		return projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}

	public JobInfo algorithmId(String algorithmId) {
		this.algorithmId = algorithmId;
		return this;
	}

	public String getAlgorithmId() {
		return algorithmId;
	}

	public void setAlgorithmId(String algorithmId) {
		this.algorithmId = algorithmId;
	}

	public JobInfo algorithmVersion(String algorithmVersion) {
		this.algorithmVersion = algorithmVersion;
		return this;
	}

	public String getAlgorithmVersion() {
		return algorithmVersion;
	}

	public void setAlgorithmVersion(String algorithmVersion) {
		this.algorithmVersion = algorithmVersion;
	}

	public JobInfo jobOwner(String jobOwner) {
		this.jobOwner = jobOwner;
		return this;
	}

	public String getJobOwner() {
		return jobOwner;
	}

	public void setJobOwner(String jobOwner) {
		this.jobOwner = jobOwner;
	}

	public JobInfo automaticallyMachineSelection(Boolean automaticallyMachineSelection) {
		this.automaticallyMachineSelection = automaticallyMachineSelection;
		return this;
	}

	public Boolean getAutomaticallyMachineSelection() {
		return automaticallyMachineSelection;
	}

	public void setAutomaticallyMachineSelection(Boolean automaticallyMachineSelection) {
		this.automaticallyMachineSelection = automaticallyMachineSelection;
	}

	public JobInfo submissionMachine(String submissionMachine) {
		this.submissionMachine = submissionMachine;
		return this;
	}

	public String getSubmissionMachine() {
		return submissionMachine;
	}

	public void setSubmissionMachine(String submissionMachine) {
		this.submissionMachine = submissionMachine;
	}

	public JobInfo submissionTime(String submissionTime) {
		this.submissionTime = submissionTime;
		return this;
	}

	public String getSubmissionTime() {
		return submissionTime;
	}

	public void setSubmissionTime(String submissionTime) {
		this.submissionTime = submissionTime;
	}

	public JobInfo executionMachine(String executionMachine) {
		this.executionMachine = executionMachine;
		return this;
	}

	public String getExecutionMachine() {
		return executionMachine;
	}

	public void setExecutionMachine(String executionMachine) {
		this.executionMachine = executionMachine;
	}

	public JobInfo endTime(String endTime) {
		this.endTime = endTime;
		return this;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public JobInfo numberOfAttempts(Integer numberOfAttempts) {
		this.numberOfAttempts = numberOfAttempts;
		return this;
	}

	public Integer getNumberOfAttempts() {
		return numberOfAttempts;
	}

	public void setNumberOfAttempts(Integer numberOfAttempts) {
		this.numberOfAttempts = numberOfAttempts;
	}

	public JobInfo description(String description) {
		this.description = description;
		return this;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public JobInfo priority(Integer priority) {
		this.priority = priority;
		return this;
	}

	public Integer getPriority() {
		return priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}

	public JobInfo state(StatusType state) {
		this.state = state;
		return this;
	}

	public StatusType getState() {
		return state;
	}

	public void setState(StatusType state) {
		this.state = state;
	}

	public JobInfo exitCode(Integer exitCode) {
		this.exitCode = exitCode;
		return this;
	}

     public Integer getExitCode() {
		return exitCode;
	}

	public void setExitCode(Integer exitCode) {
		this.exitCode = exitCode;
	}

	public JobInfo exitStatus(ExitStatusEnum exitStatus) {
		this.exitStatus = exitStatus;
		return this;
	}

     public ExitStatusEnum getExitStatus() {
		return exitStatus;
	}

	public void setExitStatus(ExitStatusEnum exitStatus) {
		this.exitStatus = exitStatus;
	}

	public JobInfo cpuTime(Double cpuTime) {
		this.cpuTime = cpuTime;
		return this;
	}

	public Double getCpuTime() {
		return cpuTime;
	}

	public void setCpuTime(Double cpuTime) {
		this.cpuTime = cpuTime;
	}

	public JobInfo wallclockTime(Integer wallclockTime) {
		this.wallclockTime = wallclockTime;
		return this;
	}

	public Integer getWallclockTime() {
		return wallclockTime;
	}

	public void setWallclockTime(Integer wallclockTime) {
		this.wallclockTime = wallclockTime;
	}

	public JobInfo ramMemory(Double ramMemory) {
		this.ramMemory = ramMemory;
		return this;
	}

	public Double getRamMemory() {
		return ramMemory;
	}

	public void setRamMemory(Double ramMemory) {
		this.ramMemory = ramMemory;
	}

	public JobInfo progressInfo(String progressInfo) {
		this.progressInfo = progressInfo;
		return this;
	}

	public String getProgressInfo() {
		return progressInfo;
	}

	public void setProgressInfo(String progressInfo) {
		this.progressInfo = progressInfo;
	}

	public JobInfo statusHistory(List<StatusChangeHistory> statusHistory) {
		this.statusHistory = statusHistory;
		return this;
	}

	public JobInfo addStatusHistoryItem(StatusChangeHistory statusHistoryItem) {
		this.statusHistory.add(statusHistoryItem);
		return this;
	}

	public List<StatusChangeHistory> getStatusHistory() {
		return statusHistory;
	}

	public void setStatusHistory(List<StatusChangeHistory> statusHistory) {
		this.statusHistory = statusHistory;
	}

	public JobInfo lastModifiedTime(String lastModifiedTime) {
		this.lastModifiedTime = lastModifiedTime;
		return this;
	}

	public String getLastModifiedTime() {
		return lastModifiedTime;
	}

	public void setLastModifiedTime(String lastModifiedTime) {
		this.lastModifiedTime = lastModifiedTime;
	}


	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		JobInfo job = (JobInfo) o;
		return Objects.equals(this.jobId, job.jobId) &&
				Objects.equals(this.sessionId, job.sessionId) &&
				Objects.equals(this.submitedBy, job.submitedBy) &&
				Objects.equals(this.projectId, job.projectId) &&
				Objects.equals(this.algorithmId, job.algorithmId) &&
				Objects.equals(this.algorithmVersion, job.algorithmVersion) &&
				Objects.equals(this.jobOwner, job.jobOwner) &&
				Objects.equals(this.automaticallyMachineSelection, job.automaticallyMachineSelection) &&
				Objects.equals(this.submissionMachine, job.submissionMachine) &&
				Objects.equals(this.submissionTime, job.submissionTime) &&
				Objects.equals(this.executionMachine, job.executionMachine) &&
				Objects.equals(this.endTime, job.endTime) &&
				Objects.equals(this.numberOfAttempts, job.numberOfAttempts) &&
				Objects.equals(this.description, job.description) &&
				Objects.equals(this.priority, job.priority) &&
				Objects.equals(this.state, job.state) &&
				Objects.equals(this.exitCode, job.exitCode) &&
				Objects.equals(this.exitStatus, job.exitStatus) &&
				Objects.equals(this.cpuTime, job.cpuTime) &&
				Objects.equals(this.wallclockTime, job.wallclockTime) &&
				Objects.equals(this.ramMemory, job.ramMemory) &&
				Objects.equals(this.progressInfo, job.progressInfo) &&
				Objects.equals(this.statusHistory, job.statusHistory) &&
				Objects.equals(this.lastModifiedTime, job.lastModifiedTime);
	}

	@Override
	public int hashCode() {
		return Objects.hash(jobId, sessionId, submitedBy, projectId, algorithmId, algorithmVersion, jobOwner, automaticallyMachineSelection, submissionMachine, submissionTime, executionMachine, endTime, numberOfAttempts, description, priority, state, exitCode, exitStatus, cpuTime, wallclockTime, ramMemory, progressInfo, statusHistory, lastModifiedTime);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class JobInfo {\n");

		sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
		sb.append("    sessionId: ").append(toIndentedString(sessionId)).append("\n");
		sb.append("    submitedBy: ").append(toIndentedString(submitedBy)).append("\n");
		sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
		sb.append("    algorithmId: ").append(toIndentedString(algorithmId)).append("\n");
		sb.append("    algorithmVersion: ").append(toIndentedString(algorithmVersion)).append("\n");
		sb.append("    jobOwner: ").append(toIndentedString(jobOwner)).append("\n");
		sb.append("    automaticallyMachineSelection: ").append(toIndentedString(automaticallyMachineSelection)).append("\n");
		sb.append("    submissionMachine: ").append(toIndentedString(submissionMachine)).append("\n");
		sb.append("    submissionTime: ").append(toIndentedString(submissionTime)).append("\n");
		sb.append("    executionMachine: ").append(toIndentedString(executionMachine)).append("\n");
		sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
		sb.append("    numberOfAttempts: ").append(toIndentedString(numberOfAttempts)).append("\n");
		sb.append("    description: ").append(toIndentedString(description)).append("\n");
		sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
		sb.append("    state: ").append(toIndentedString(state)).append("\n");
		sb.append("    exitCode: ").append(toIndentedString(exitCode)).append("\n");
		sb.append("    exitStatus: ").append(toIndentedString(exitStatus)).append("\n");
		sb.append("    cpuTime: ").append(toIndentedString(cpuTime)).append("\n");
		sb.append("    wallclockTime: ").append(toIndentedString(wallclockTime)).append("\n");
		sb.append("    ramMemory: ").append(toIndentedString(ramMemory)).append("\n");
		sb.append("    progressInfo: ").append(toIndentedString(progressInfo)).append("\n");
		sb.append("    statusHistory: ").append(toIndentedString(statusHistory)).append("\n");
		sb.append("    lastModifiedTime: ").append(toIndentedString(lastModifiedTime)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}
}
