/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.nonblockingnio;

import csfs.datatransfer.DataTransferMethod;
import csfs.datatransfer.nonblockingnio.NonBlockingNIOClient;
import csfs.impl.util.Util;
import csfs.remote.InvalidStateException;
import csfs.remote.NotFileException;
import csfs.remote.RemoteFile;
import csfs.remote.ServerException;
import java.io.File;
import java.io.IOException;

public class NonBlockingNIOMethod
implements DataTransferMethod {
    @Override
    public boolean copy(File localFile, RemoteFile destination, String method) throws NotFileException, InvalidStateException, IOException, ServerException {
        String nioAddress = destination.getFileServer().getCopyServerAddress(method);
        int index = nioAddress.lastIndexOf(58);
        String host = nioAddress.substring(0, index);
        int port = Integer.parseInt(nioAddress.substring(index + 1));
        String targetFilename = Util.stringArrayToString(destination.getFullName());
        NonBlockingNIOClient client = new NonBlockingNIOClient();
        return client.sendFile(host, port, localFile.getAbsolutePath(), targetFilename);
    }

    @Override
    public String getName() {
        return "BLOCKING_NIO";
    }

    @Override
    public String getDetailedInfo() {
        return "BLOCKING_NIO METHOD";
    }
}

