/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.AbstractBufferManager;
import org.jacorb.orb.buffermanager.BufferManagerExpansionPolicy;
import org.jacorb.orb.buffermanager.DefaultExpansionPolicy;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_MEMORY;
import org.slf4j.Logger;

public class BufferManager
extends AbstractBufferManager {
    private static final int MIN_CACHE = 9;
    private static final double LOG2 = Math.log(2.0);
    protected final Collection[] bufferPool;
    private byte[] bufferMax = null;
    private final int maxManagedBufferSize;
    private final int threshold;
    private Reaper reaper;
    private final int time;
    private BufferManagerExpansionPolicy expansionPolicy;
    private final Logger logger;

    public BufferManager(Configuration configuration) {
        this.logger = configuration.getLogger("org.jacorb.orb.buffermanager");
        try {
            this.time = configuration.getAttributeAsInteger("jacorb.bufferManagerMaxFlush", 0);
            this.maxManagedBufferSize = configuration.getAttributeAsInteger("jacorb.maxManagedBufSize", 22);
            this.threshold = configuration.getAttributeAsInteger("jacorb.bufferManagerThreshold", 20);
        }
        catch (ConfigurationException ex) {
            this.logger.error("Error configuring the BufferManager", (Throwable)ex);
            throw new INTERNAL("Unable to configure the BufferManager");
        }
        try {
            this.expansionPolicy = (BufferManagerExpansionPolicy)configuration.getAttributeAsObject("jacorb.buffermanager.expansionpolicy", DefaultExpansionPolicy.class.getName());
            if (this.expansionPolicy instanceof Configurable) {
                ((Configurable)((Object)this.expansionPolicy)).configure(configuration);
            }
        }
        catch (ConfigurationException e) {
            this.expansionPolicy = null;
        }
        this.bufferPool = this.initBufferPool(configuration, this.maxManagedBufferSize);
        int[] sizes = new int[]{1023, 2047};
        for (int i = 0; i < sizes.length; ++i) {
            for (int min = 0; min < 10; ++min) {
                int position = BufferManager.calcLog(sizes[i]) - 9;
                this.storeBuffer(position, new byte[sizes[i]]);
            }
        }
        if (this.time > 0) {
            if (this.reaper != null) {
                this.reaper.dispose();
            }
            this.reaper = new Reaper(this.time);
            this.reaper.setName("BufferManager MaxCache Reaper");
            this.reaper.setDaemon(true);
            this.reaper.start();
        }
    }

    protected void storeBuffer(int position, byte[] buffer) {
        this.bufferPool[position].add(buffer);
    }

    protected Collection[] initBufferPool(Configuration configuration, int maxSize) {
        Collection[] bufferPool = new List[maxSize];
        for (int i = 0; i < bufferPool.length; ++i) {
            bufferPool[i] = new ArrayList(this.threshold);
        }
        return bufferPool;
    }

    private static final int calcLog(int value) {
        if (value <= 1023) {
            return 9;
        }
        return (int)Math.floor(Math.log(value) / LOG2);
    }

    @Override
    public byte[] getExpandedBuffer(int size) {
        if (size < 0) {
            throw new INTERNAL("Unable to cache and create buffer of negative size. Possible overflow issue.");
        }
        if (this.expansionPolicy != null) {
            size = this.expansionPolicy.getExpandedSize(size);
        }
        return this.getBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBuffer(int size) {
        byte[] result = null;
        if (size < 0) {
            throw new INTERNAL("Unable to cache and create buffer of negative size. Possible overflow issue.");
        }
        int log = BufferManager.calcLog(size);
        if (log > this.maxManagedBufferSize) {
            try {
                if (this.time < 0) {
                    result = new byte[size];
                }
                BufferManager bufferManager = this;
                synchronized (bufferManager) {
                    if (this.bufferMax == null || this.bufferMax.length < size) {
                        this.bufferMax = new byte[size];
                    }
                    result = this.bufferMax;
                    this.bufferMax = null;
                }
            }
            catch (OutOfMemoryError e) {
                throw new NO_MEMORY(e.toString());
            }
        } else {
            int index = log > 9 ? log - 9 : 0;
            Collection s = this.bufferPool[index];
            result = this.doFetchBuffer(s);
            if (result == null) {
                result = new byte[(log > 9 ? 1 << log + 1 : 1024) - 1];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doFetchBuffer(Collection list) {
        Collection collection = list;
        synchronized (collection) {
            int size = list.size();
            if (size > 0) {
                return (byte[])((AbstractList)list).remove(size - 1);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnBuffer(byte[] current, boolean cdrStr) {
        int log_curr;
        if (current != null && (log_curr = BufferManager.calcLog(current.length)) >= 9) {
            if (log_curr > this.maxManagedBufferSize) {
                BufferManager bufferManager = this;
                synchronized (bufferManager) {
                    if (cdrStr && this.time >= 0 && (this.bufferMax == null || this.bufferMax.length < current.length)) {
                        this.bufferMax = current;
                    }
                    return;
                }
            }
            int expected = (1 << log_curr + 1) - 1;
            if (current.length != expected) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("BufferManager.returnBuffer, log  = " + log_curr + " got length " + current.length + " expected length " + expected);
                }
            } else {
                Collection s = this.bufferPool[log_curr - 9];
                this.doReturnBuffer(s, current, this.threshold);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReturnBuffer(Collection list, byte[] buffer, int threshold) {
        Collection collection = list;
        synchronized (collection) {
            if (list.size() < threshold) {
                list.add(buffer);
            }
        }
    }

    @Override
    public void release() {
        for (int i = 0; i < this.bufferPool.length; ++i) {
            this.bufferPool[i].clear();
        }
        if (this.reaper != null) {
            this.reaper.dispose();
            this.reaper = null;
        }
    }

    static /* synthetic */ byte[] access$002(BufferManager x0, byte[] x1) {
        x0.bufferMax = x1;
        return x1;
    }

    private final class Reaper
    extends Thread {
        private boolean done;
        private int sleepInterval;

        public Reaper(int sleepInterval) {
            super("BufferManagerReaper");
            this.done = false;
            this.sleepInterval = 0;
            this.sleepInterval = sleepInterval * 1000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                long time = (long)this.sleepInterval + System.currentTimeMillis();
                Object object = this;
                synchronized (object) {
                    while (!this.done && System.currentTimeMillis() <= time) {
                        try {
                            this.wait(this.sleepInterval);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                object = this;
                synchronized (object) {
                    if (this.done) {
                        break;
                    }
                }
                object = BufferManager.this;
                synchronized (object) {
                    BufferManager.access$002(BufferManager.this, null);
                }
            }
        }

        public synchronized void dispose() {
            this.done = true;
            this.interrupt();
            this.notify();
        }
    }
}

