/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl.channel;

import csfs.impl.filetracker.FileTracker;
import csfs.impl.filetracker.FileTrackerLeasing;
import csfs.remote.ClosedChannelException;
import csfs.remote.InvalidStateException;
import csfs.remote.RemoteFile;
import csfs.remote.RemoteFileHelper;
import csfs.remote.ServerException;
import csfs.remote.WriteChannelPOA;
import java.io.IOException;
import java.io.OutputStream;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;

public class WriteChannelDefaultServantImpl
extends WriteChannelPOA {
    @Override
    public int write(int size, byte[] buffer) throws ClosedChannelException, InvalidStateException, ServerException {
        int response = 0;
        OutputStream outputStream = this.getOutputStream();
        if (outputStream != null) {
            try {
                outputStream.write(buffer, 0, size);
                outputStream.flush();
                response = size;
            }
            catch (IOException exc) {
                exc.printStackTrace();
                throw new InvalidStateException("Unable to perform write operation: " + exc.getMessage(), this.getFile().getFullName());
            }
        } else {
            throw new ClosedChannelException(this._this());
        }
        return response;
    }

    @Override
    public void close() throws InvalidStateException {
        FileTracker tracker = FileTrackerLeasing.getInstance();
        tracker.removeFileDescriptor(this.getObjectId());
    }

    @Override
    public RemoteFile getFile() throws InvalidStateException, ServerException {
        String channelID = this.getObjectId();
        String fileID = channelID.substring(0, channelID.lastIndexOf(95));
        return this.createRemoteFile(fileID);
    }

    @Override
    public boolean isOpen() throws InvalidStateException {
        return this.getOutputStream() != null;
    }

    private OutputStream getOutputStream() throws InvalidStateException {
        return (OutputStream)FileTrackerLeasing.getInstance().getFileDescriptor(this.getObjectId());
    }

    private String getObjectId() throws InvalidStateException {
        return new String(this._object_id());
    }

    private RemoteFile createRemoteFile(String path) throws InvalidStateException, ServerException {
        Object o = null;
        try {
            o = this._poa().the_parent().create_reference_with_id(path.getBytes(), RemoteFileHelper.type().id());
        }
        catch (UserException ex) {
            ex.printStackTrace();
            throw new InvalidStateException("Internal misconfiguration problem: " + ex.getMessage(), this.getFile().getFullName());
        }
        return RemoteFileHelper.narrow(o);
    }
}

