/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.blockingnio;

import csfs.datatransfer.blockingnio.BlockingNIOReceiverThread;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.util.logging.Logger;

public class BlockingNIOServer
extends Thread {
    private String rootDir;
    private int port;
    private int tcpBuffer;

    public BlockingNIOServer(String rootDir, int port, int tcpBuffer) {
        this.rootDir = rootDir;
        this.port = port;
        this.tcpBuffer = tcpBuffer;
    }

    @Override
    public void run() {
        try {
            ServerSocket server = ServerSocketChannel.open().socket();
            if (this.tcpBuffer != 0) {
                System.out.println("TCP_BUFFER=" + this.tcpBuffer);
                server.setReceiveBufferSize(this.tcpBuffer);
                System.out.println("ReceiveBufferSize=" + server.getReceiveBufferSize());
            }
            String localhost = InetAddress.getLocalHost().getHostName();
            server.bind(new InetSocketAddress(localhost, this.port));
            Logger.global.info("NIOCopyServer BOUND TO:" + this.port);
            while (true) {
                Socket socket = server.accept();
                if (this.tcpBuffer != 0) {
                    socket.setSendBufferSize(this.tcpBuffer);
                    System.out.println("SendBufferSize=" + socket.getSendBufferSize());
                }
                BlockingNIOReceiverThread t = new BlockingNIOReceiverThread(socket, this.rootDir);
                t.setPriority(this.getPriority() - 1);
                t.start();
            }
        }
        catch (BindException exc) {
            Logger.global.severe("NIOCopyServer DID NOT start at this process!!! SOMETHING WAS ALREADY BOUND!!!");
        }
        catch (IOException exc) {
            Logger.global.severe("NIOCopyServer SHUT DOWN!");
            exc.printStackTrace();
        }
    }
}

