# $Id: config.mak 166235 2015-07-08 18:31:13Z fpina $

PROJNAME = csbase
APPNAME  = sgad

USE_RCS    = Yes
USE_LUA51  = Yes
USE_STATIC = Yes
# BUILD_DYLIB = Yes

LUASRC = \
	lib/PBSPro.lua \
	lib/shellExtension.lua \
	lib/torquePBS.lua \
	lib/Unix_patterns.lua \
	lib/Unix_processes.lua \
	main.lua \
	sga/command.lua \
	sga/daemon.lua \
	sga/services.lua \
	sga/verbose.lua \
	sga/parsed.lua \
	sga/idlaux.lua \
	sga/idl.lua

# Windows
SRC = ../obj/sgad/Win32/sgalua.c sgautils.cpp sgad.cpp
# Outros
SRC = $(PRELOAD_DIR)/sgalua.c sgautils.cpp sgad.cpp
# EXPCFG = sgad-cnf.lua sgad-cnfavc.lua sga-daemon

SGAIDLDIR = ../idl

IDLSRC = $(SGAIDLDIR)/sga.idl

DEPENDENTIDLSRC = \
	$(SGAIDLDIR)/sga-common.idl \
	$(SGAIDLDIR)/sga-daemon.idl \
	$(SGAIDLDIR)/sga-manager.idl

INCLUDES = \
	. \
	$(LUASTRUCT_HOME)/src \
	$(LUASOCKET_HOME)/include \
	$(LUATUPLE_HOME)/obj/$(TEC_UNAME) \
	$(LOOP_HOME)/obj/$(TEC_UNAME) \
	$(LUACOTHREAD_HOME)/obj/$(TEC_UNAME) \
	$(LUAIDL_HOME)/obj/$(TEC_UNAME) \
	$(OIL_HOME)/obj/$(TEC_UNAME) \
	$(LUASEC_HOME)/include

include ${OIL_HOME}/openbus/base.mak

ifdef USE_LUA51
	INCLUDES+= $(LUACOMPAT52_HOME)/c-api $(LUACOMPAT52_HOME)/obj/$(TEC_UNAME)
endif

ifneq ($(findstring Win, $(TEC_SYSNAME)), )
	APPTYPE=console

	SRC += lib/Windows.cpp
	LUASRC += lib/Windows.lua

	LIBS := \
		luastruct \
		luasocket \
		luatuple \
		loop \
		luacothread \
		luaidl \
		oil \
		luasec

	LIBS += wsock32

	LDIR += \
		$(LUASTRUCT_HOME)/lib/$(TEC_UNAME) \
		$(LUASOCKET_HOME)/lib/$(TEC_UNAME) \
		$(LUATUPLE_HOME)/lib/$(TEC_UNAME) \
		$(LOOP_HOME)/lib/$(TEC_UNAME) \
		$(LUACOTHREAD_HOME)/lib/$(TEC_UNAME) \
		$(LUAIDL_HOME)/lib/$(TEC_UNAME) \
		$(OIL_HOME)/lib/$(TEC_UNAME) \
		$(LUASEC_HOME)/lib/$(TEC_UNAME)

	ifdef USE_LUA51
		LDIR += $(LUACOMPAT52_HOME)/lib/$(TEC_UNAME)
		LIBS += luacompat52 luabit32 luacompat52c
	endif
	ifneq ($(findstring dll, $(TEC_UNAME)), ) # USE_DLL
		ifdef DBG
			LIBS+= libeay32MDd ssleay32MDd
		else
			LIBS+= libeay32MD ssleay32MD
		endif
		LDIR+= $(OPENSSL_HOME)/lib/VC
	else
		ifdef DBG
			LIBS+= libeay32MTd ssleay32MTd
		else
			LIBS+= libeay32MT ssleay32MT
		endif
		LDIR+= $(OPENSSL_HOME)/lib/VC/static
	endif
else
	SLIB += \
		$(LUASTRUCT_HOME)/lib/$(TEC_UNAME)/libluastruct.a \
		$(LUASOCKET_HOME)/lib/$(TEC_UNAME)/libluasocket.a \
		$(LUATUPLE_HOME)/lib/$(TEC_UNAME)/libluatuple.a \
		$(LOOP_HOME)/lib/$(TEC_UNAME)/libloop.a \
		$(LUACOTHREAD_HOME)/lib/$(TEC_UNAME)/libluacothread.a \
		$(LUAIDL_HOME)/lib/$(TEC_UNAME)/libluaidl.a \
		$(OIL_HOME)/lib/$(TEC_UNAME)/liboil.a \
		$(LUASEC_HOME)/lib/$(TEC_UNAME)/libluasec.a \
		../../openssl-1.0.0m/libssl.a \
		../../openssl-1.0.0m/libcrypto.a

		# ./build/lua-5.1.3-oblibs1.3.2/lib/MacOS109/liblua5.1.a
		# ./build/lua-5.1.3snapshot/lib/MacOS109/liblua5.1.a
		

	ifdef USE_LUA51
		SLIB += \
			$(LUACOMPAT52_HOME)/lib/$(TEC_UNAME)/libluacompat52.a \
			$(LUACOMPAT52_HOME)/lib/$(TEC_UNAME)/libluabit32.a \
			$(LUACOMPAT52_HOME)/lib/$(TEC_UNAME)/libluacompat52c.a
	endif

	SRC += lib/Unix.cpp
	LUASRC += lib/Unix.lua
	LIBS += dl
endif

ifeq "$(TEC_SYSNAME)" "Linux"
	# LFLAGS += -static
	LFLAGS += -rdynamic
endif

ifeq "$(TEC_UNAME)" "IRIX6465"
#   CPPC = CC
#   STDFLAGS = -LANG:std -OPT:Olimit_opt=on -G 4 -LANG:ansi-for-init-scope -woff 1682,1110,1116,1014,1681
endif

ifeq "$(TEC_UNAME)" "AIX43"
	CFLAGS += -g
#  LDIR += $(GCC_EXEC_PREFIX)
#  LFLAGS += -Wl,-brtl,-bbigtoc
#  LFLAGS += -Bstatic
endif

ifeq "$(TEC_SYSNAME)" "SunOS"
	LIBS += socket nsl
	LFLAGS += -static-libgcc
endif

ifeq "$(CC)" "g++"
	CPPFLAGS += -ftemplate-depth-42 -fpermissive $(INCS)
endif

sga/parsed.lua: $(IDL2LUA) $(IDLSRC) $(DEPENDENTIDLSRC)
	$(OILBIN) $(IDL2LUA) -I $(SGAIDLDIR) -o $@ $(IDLSRC)

# $(PRELOAD_DIR)/sgalua.c: $(LUAPRELOADER) $(LUASRC)
# $(PRELOAD_DIR)/sgalua.c: $(PRELOAD_DIR)/sgalua.h

# Outros
../obj/sgad/$(TEC_UNAME)/sgalua.c: $(LUAPRELOADER) $(LUASRC)
	$(LOOPBIN) $(LUAPRELOADER) \
	-l "?.lua" \
	-d $(PRELOAD_DIR) \
	-h sgalua.h \
	-o sgalua.c \
	$(LUASRC)

#Windows
# ../obj/sgad/Win64/sgalua.c: $(LUAPRELOADER) $(LUASRC)
# 	$(LOOPBIN) $(LUAPRELOADER) \
# 	-l "?.lua" \
# 	-d $(PRELOAD_DIR) \
# 	-o sgalua.c \
# 	-h sgalua.h \
# 	$(LUASRC)
