/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.nonblockingnio;

import csfs.datatransfer.nonblockingnio.ImportHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;

public class NonBlockingNIOServer
extends Thread {
    private static final int DEFAULT_PORT_NUMBER = 7780;
    private Selector selector;
    private String rootDir = ".";
    private int port = 7780;

    public static void main(String[] args) {
        int port = NonBlockingNIOServer.getServerPort(args);
        new NonBlockingNIOServer("", port).start();
    }

    private static int getServerPort(String[] args) {
        int port = 7780;
        if (args.length > 0) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ex) {
                System.out.println("Uso: java FTPNIOServer <numero_porta>");
                System.exit(1);
            }
        }
        return port;
    }

    public NonBlockingNIOServer(String rootDir, int port) {
        this.rootDir = rootDir;
        this.port = port;
    }

    private ServerSocketChannel createServerSocketChannel(int port) throws IOException {
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        ServerSocket serverSocket = serverChannel.socket();
        serverSocket.bind(new InetSocketAddress(port));
        Logger.global.info("NonBlockingNIOServer BOUND TO:" + port);
        serverChannel.configureBlocking(false);
        return serverChannel;
    }

    private void acceptConnection(SelectionKey key) throws IOException {
        ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
        SocketChannel clientChannel = serverChannel.accept();
        this.registerChannel(clientChannel, 1);
        ImportHandler.createHandler(clientChannel, this.rootDir);
    }

    private void registerChannel(SelectableChannel channel, int ops) throws IOException {
        if (channel == null) {
            return;
        }
        channel.configureBlocking(false);
        channel.register(this.selector, ops);
    }

    private void handleRead(SelectionKey key) throws Exception {
        SocketChannel clientChannel = null;
        clientChannel = (SocketChannel)key.channel();
        ImportHandler handler = ImportHandler.getHandler(clientChannel);
        if (handler == null) {
            throw new Exception("Handler n\u201eo encontrado!!!");
        }
        handler.read();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            System.err.println("N\u201eo foi poss\u00ccvel criar o multiplexador.");
            e.printStackTrace();
        }
        serverChannel = null;
        try {
            serverChannel = this.createServerSocketChannel(this.port);
            serverChannel.register(this.selector, 16);
        }
        catch (ClosedChannelException e) {
            System.err.println("N\u201eo foi poss\u00ccvel registrar o socket do servidor.");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("N\u201eo foi poss\u00ccvel criar o socket do servidor.");
            e.printStackTrace();
        }
        try {
            block8: while (true) {
                selectedKeysCount = 0;
                selectedKeysCount = this.selector.select();
                if (selectedKeysCount == 0) continue;
                it = this.selector.selectedKeys().iterator();
                while (true) {
                    if (it.hasNext()) ** break;
                    continue block8;
                    key = it.next();
                    if (key.isAcceptable()) {
                        this.acceptConnection(key);
                    }
                    if (key.isReadable()) {
                        this.handleRead(key);
                    }
                    it.remove();
                }
                break;
            }
        }
        catch (IOException e) {
            System.err.println("N\u201eo foi poss\u00ccvel tratar um evento do servidor.");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("N\u201eo foi poss\u00ccvel tratar um evento do servidor.");
            e.printStackTrace();
        }
    }
}

