/**
 * $Id: SSHUtils.java 166873 2015-07-29 17:10:42Z fpina $
 */

package csbase.sshclient;

import java.security.PublicKey;

import net.schmizz.sshj.transport.verification.HostKeyVerifier;

/**
 * SSHUtils.
 *
 * @author Tecgraf
 */
public class SSHUtils {

  /**
   * Adds a blank host key verifier that returns true for all input.
   *
   * @param ssh the SSHClient to add the verifier
   */
  static public void addBlankHostKeyVerifier(net.schmizz.sshj.SSHClient ssh) {
    ssh.addHostKeyVerifier(new HostKeyVerifier() {
      @Override
      public boolean verify(String host, int port, PublicKey key) {
        return true;
      }
    });
  }
}
