/**
 * $Id: SSHUtils.java 182695 2022-06-21 19:15:27Z fpina $
 */

package csbase.sshclient;

import java.security.PublicKey;
import java.util.Collections;
import java.util.List;

import net.schmizz.sshj.transport.verification.HostKeyVerifier;

/**
 * SSHUtils.
 *
 * @author Tecgraf
 */
public class SSHUtils {

  /**
   * Adds a blank host key verifier that returns true for all input.
   *
   * @param ssh the SSHClient to add the verifier
   */
  static public void addBlankHostKeyVerifier(net.schmizz.sshj.SSHClient ssh) {
    ssh.addHostKeyVerifier(new HostKeyVerifier() {
      @Override
      public boolean verify(String host, int port, PublicKey key) {
        return true;
      }

      @Override
      public List<String> findExistingAlgorithms(String host, int port) {
        return Collections.emptyList();
      }
    });
  }
}
