#include <iostream>
#include <string.h>
#include <wioapi.h>
#include <errno.h>
#include <stdlib.h>

using namespace std;
using namespace wioapi;

const char* JAVAWS_CMD = "/usr/java/jdk/bin/javaws";

char* getParameter(const char* cmdOption, int argc, 
char *argv[], bool mandatory) {
  for (int i=0; i<argc; i++) {
     // se um dos parametros da linha de comando comeca por ...
     if (strstr(argv[i], cmdOption) == argv[i]) {
          cout << cmdOption << " = " << argv[i+1] << endl;
          return i < argc ? argv[i+1] : NULL;
     }
  }
  if (mandatory) {
    cout << "No parameter: " << cmdOption << endl;
    cout << "Usage:\n" << argv[0] <<
	      " --user <user>" <<
              " --passwd <pwd> --server <server> --port <port>" <<
              " --project <project> --algorithm <algorithm>" <<
              "\n" 
              << endl;
    exit(1);
  }
   return NULL;
}

int main( int argc, char *argv[], char *envp[] ) {
  WIOFileSystem* wioFileSystem = NULL;
  
  try {
    const char* user = getParameter("--user", argc, argv, true);
    const char* pwd = getParameter("--passwd", argc, argv, true);
    const char* server = getParameter("--server", argc, argv, true);
    const char* port = getParameter("--port", argc, argv, true);
    const char* project = getParameter("--project", argc, argv, true);
    const char* algorithm = getParameter("--algorithm", argc, argv, true);

    cout << endl;

    void* orb = WIOLocator::startORB(argc, argv);
    if (orb == NULL) {
        cout << "No ORB found! Bye!" << endl;
        exit(1);
    }

    const char* ior = WIOLocator::createIOR(server, port);
    cout << "IOR for file system: " << ior << endl << endl;

    wioFileSystem = WIOLocator::buildFileSystem(ior);
    cout << "File system built!" << endl;
    cout << "WIO Server Version: : [" << wioFileSystem->getServerVersion() << endl;

    WIOAlgorithmInfo info;
    info.algorithmName = algorithm;
    info.algorithmParameterAmount = 1;
    info.algorithmParameters = (WIOAlgorithmParameter*)calloc (info.algorithmParameterAmount, sizeof (WIOAlgorithmParameter));
    WIOAlgorithmParameter * parameter;

    parameter = (WIOAlgorithmParameter*) malloc (sizeof(WIOAlgorithmParameter));
    parameter->name = strdup ("real");
    parameter->value = strdup ("10.6");
    info.algorithmParameters[0] = (*parameter);
    
/*    parameter = (WIOAlgorithmParameter*) malloc (sizeof(WIOAlgorithmParameter));
    parameter->name = strdup ("Nome_01");
    parameter->value = strdup ("Valor_01");
    info.algorithmParameters[0] = (*parameter);

    parameter = (WIOAlgorithmParameter*) malloc (sizeof(WIOAlgorithmParameter));
    parameter->name = strdup ("Nome_02");
    parameter->value = strdup ("Valor_02");
    info.algorithmParameters[1] = (*parameter);

    parameter = (WIOAlgorithmParameter*) malloc (sizeof(WIOAlgorithmParameter));
    parameter->name = strdup ("Nome_03");
    parameter->value = strdup ("Valor_03");
    info.algorithmParameters[2] = (*parameter);
 */

    char* url = wioFileSystem->preLogin2Web(user, pwd, project, info);
    cout << "URL: " << url << endl;
    delete[] info.algorithmParameters;
  }
  catch(wioapi::Exception* ex) {
    cout << "EXCEPTION FOR WIO DETECTED! AHHH!" << endl;
    cout << ex->getServerMessage() << endl;
    cout << ex->getClientMessage() << endl;
  }
  catch(...) {
    cout << "Something strange happened! AHHH!" << endl;
  }
  
  delete wioFileSystem;
  
  return 0;
}
