package csdk.v2.helper.application;

import csdk.v2.api.application.IMessageSender;

/**
 * Identifica a aplicao que enviou uma mensagem.
 */
public class MessageSender implements IMessageSender {

  /** O tipo da aplicao que enviou a mensagem. */
  private final String applicationType;

  /** O identificador nico da instncia da aplicao que enviou a mensagem. */
  private final String instanceId;

  /**
   * Construtor.
   * 
   * @param applicationType o tipo da aplicao.
   * @param instanceId o identificador nico da instncia da aplicao.
   */
  public MessageSender(String applicationType, String instanceId) {
    this.applicationType = applicationType;
    this.instanceId = instanceId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getApplicationType() {
    return applicationType;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getApplicationInstanceId() {
    return instanceId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return instanceId + "(" + applicationType + ")";
  }

}
