package csdk.v2.helper.command.parameters;

/**
 * Valor de um parmetro do tipo tabela.
 */
public class TableParameterValue extends
  AbstractParameterValue<IParameterValue<?>[][]> {

  /**
   * Construtor.
   */
  public TableParameterValue() {
    super(new IParameterValue<?>[0][0]);
  }

  /**
   * Construtor.
   * 
   * @param value valores da tabela.
   */
  public TableParameterValue(IParameterValue<?>[][] value) {
    super(value);
  }

  /**
   * Adiciona uma nova linha da valores  tabela.
   * 
   * @param row a linha de valores.
   */
  public void addRow(IParameterValue<?>[] row) {
    IParameterValue<?>[][] rows = this.getValue();
    IParameterValue<?>[][] newRows = new IParameterValue[rows.length + 1][];
    System.arraycopy(rows, 0, newRows, 0, rows.length);
    newRows[rows.length] = row;
    setValue(newRows);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ParameterValueConverter<IParameterValue<?>[][]> getValueConverter() {
    return new TableValueConverter();
  }

}
