package csdk.v1_0.helper.application;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;

/**
 * Ao genrica de uma aplicao com criao de textos e imagens da prpria
 * aplicao.
 * 
 * @author Tecgraf/PUC-Rio
 * @param <A> a classe da aplicao.
 */
public abstract class AbstractApplicationAction<A extends AbstractApplication>
  extends AbstractAction {

  /**
   * Aplicao que lanou a ao.
   */
  final private A application;

  /**
   * Consulta  aplicao.
   * 
   * @return a aplicao.
   */
  public A getApplication() {
    return application;
  }

  /**
   * Construtor.
   * 
   * @param application a aplicao
   * @param label nome da ao.
   * @param icon cone da ao.
   */
  public AbstractApplicationAction(A application, String label, ImageIcon icon) {
    super();
    this.application = application;
    setName(label);
    setIcon(icon);
  }

  /**
   * Construtor.
   * 
   * @param application a aplicao
   */
  public AbstractApplicationAction(A application) {
    this(application, null, null);
  }

  /**
   * Atribui o nome da ao.
   * 
   * @param label o nome.
   */
  public void setName(String label) {
    putValue(Action.NAME, label);
  }

  /**
   * Atribui o tooltip da ao.
   * 
   * @param label o nome.
   */
  public void setTooltip(String label) {
    putValue(Action.SHORT_DESCRIPTION, label);
  }

  /**
   * Atribui o cone da ao.
   * 
   * @param icon o cone.
   */
  public void setIcon(ImageIcon icon) {
    putValue(Action.SMALL_ICON, icon);
  }

  /**
   * Indica se um texto de internacionalizao foi definido usando uma chave
   * prefixada com o nome da classe. Obtm dinamicamente o nome da classe para
   * usar como prefixo da busca.
   * 
   * @param key_suffix o sufixo da chave. A chave ser: \"
   *        {@code getClass().getSimpleName()}.{@code key_sufix}\"
   * 
   * @return <code>true</code> se o texto foi definido ou <code>false</code>
   *         caso contrrio.
   */
  protected boolean hasClassString(String key_suffix) {
    return application.hasClassString(getClass(), key_suffix);
  }

  /**
   * Retorna um texto de internacionalizao, usando uma chave prefixada pelo
   * nome da classe. Obtm dinamicamente o nome da classe para usar como prefixo
   * da busca.
   * 
   * @param key_suffix o sufixo da chave. A chave ser: \"
   *        {@code getClass().getSimpleName()}.{@code key_sufix}\"
   * 
   * @param args argumentos do texto. O texto ser formatado utilizando-se da
   *        classe {@link MessageFormat}.
   * 
   * @return o texto internacionalizado.
   */
  protected String getClassString(String key_suffix, Object... args) {
    if (application.hasClassString(getClass(), key_suffix)) {
      return application.getClassString(getClass(), key_suffix);
    }
    return null;
  }

  /**
   * Indica se um texto de internacionalizao foi definido usando a chave
   * definida.
   * 
   * @param key o sufixo da chave.
   * 
   * @return <code>true</code> se o texto foi definido ou <code>false</code>
   *         caso contrrio.
   */
  protected boolean hasString(String key) {
    return application.hasString(key);
  }

  /**
   * Retorna um texto de internacionalizao usando a chave definida.
   * 
   * @param key o sufixo da chave.
   * 
   * @param args argumentos do texto. O texto ser formatado utilizando-se da
   *        classe {@link MessageFormat}.
   * 
   * @return o texto internacionalizado.
   */
  protected String getString(String key, Object... args) {
    if (application.hasString(key)) {
      return application.getString(key, args);
    }
    return null;
  }

  /**
   * Resultado da ao.
   * 
   * @param ae evento Java
   */
  @Override
  abstract public void actionPerformed(ActionEvent ae);
}
