package csdk.v2.rest.helper.exception;

import javax.ws.rs.core.Response;

/**
 * Base para a implementao de erros JSON
 *
 * @author Tecgraf/PUC-Rio
 */
public class JSONException extends RESTException{

    /**
     * Construtor da exceo
     *
     * @param message Mensagem extra de erro
     * @param cause Causa da exceo
     */
    public JSONException(String message, Throwable cause) {
        super(message, cause, Response.Status.BAD_REQUEST);
    }

    /**
     * Construtor da exceo
     *
     * @param message Mensagem extra de erro
     */
    public JSONException(String message) {
        super(message, Response.Status.BAD_REQUEST);
    }

}
