/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner.application;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IApplication;
import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.IMessageSender;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.api.core.IContext;
import csdk.v2.api.filesystem.project.IProjectContext;
import csdk.v2.api.filesystem.project.IProjectObserver;
import csdk.v2.runner.ApplicationManager;
import csdk.v2.runner.ApplicationRegistry;
import csdk.v2.runner.CSDKLogger;
import csdk.v2.runner.IContextFactory;
import csdk.v2.runner.Runner;
import csdk.v2.runner.core.RunnerEnvironment;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Map;

public class RunnerApplication
implements IApplication {
    private static int instanceCounter = 0;
    private final IApplication application;
    private final RunnerEnvironment runnerEnv;

    public RunnerApplication(ApplicationRegistry registry) throws ApplicationException {
        String id = registry.getApplicationId();
        String instanceId = RunnerApplication.generateInstanceId(id);
        Charset charset = Runner.getCharset();
        this.runnerEnv = this.createCSDKEnvironment(instanceId, registry, charset);
        Class<? extends IApplication> appClass = this.loadApplicationClass(registry);
        if (appClass == null) {
            String pattern = "No class found for {0}.";
            String message = MessageFormat.format(pattern, id);
            throw new ApplicationException(message);
        }
        try {
            Constructor<? extends IApplication> constructor = appClass.getConstructor(ICSDKEnvironment.class);
            this.application = constructor.newInstance(this.runnerEnv);
        }
        catch (InvocationTargetException e) {
            Throwable appException = e.getTargetException();
            String pattern = "Error instantiating application {0} main class {1}.\nMessage: {2}";
            String message = MessageFormat.format(pattern, id, appClass.getName(), appException.getLocalizedMessage());
            throw new ApplicationException(message, appException);
        }
        catch (NoSuchMethodException e) {
            String pattern = "Application {0} is not configured correctly or has implementation problems.\nThe main class {1} has no public valid constructor.";
            String message = MessageFormat.format(pattern, id, appClass.getName());
            throw new ApplicationException(message, (Throwable)e);
        }
        catch (InstantiationException e) {
            String pattern = "Application {0} has instanciation problems.\nPossible cause: Application main class {1} is abstract.";
            String message = MessageFormat.format(pattern, id, appClass.getName());
            throw new ApplicationException(message, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String pattern = "Application {0} has implementation problems in its main class {1}.";
            String message = MessageFormat.format(pattern, id, appClass.getName());
            throw new ApplicationException(message, (Throwable)e);
        }
    }

    private Class<? extends IApplication> loadApplicationClass(ApplicationRegistry reg) throws ApplicationException {
        try {
            ClassLoader classloader = reg.getClassloader();
            Class<?> loadedClass = Class.forName(reg.getClassName(), true, classloader);
            if (IApplication.class.isAssignableFrom(loadedClass)) {
                return loadedClass;
            }
            String pattern = "Aplication main class must implement interface {0}.";
            String message = MessageFormat.format(pattern, IApplication.class.getName());
            throw new IllegalArgumentException(message);
        }
        catch (Exception e) {
            throw new ApplicationException("Error loading application main class", (Throwable)e);
        }
    }

    private RunnerEnvironment createCSDKEnvironment(String instanceId, ApplicationRegistry registry, Charset charset) throws ApplicationException {
        ApplicationManager appManager = ApplicationManager.getInstance();
        IContextFactory contextFactory = appManager.getContextFactory();
        Map<Class<? extends IContext>, IContext> contexts = contextFactory.createCSDKContexts(instanceId, registry, appManager.getRunnerProperties());
        if (contexts == null || contexts.isEmpty() || !contexts.containsKey(IApplicationContext.class)) {
            throw new ApplicationException("Context factory must create the mandatory context " + IApplicationContext.class.getSimpleName());
        }
        if (registry.requiresProject()) {
            if (!contexts.containsKey(IProjectContext.class)) {
                throw new ApplicationException("Application cannot be run without a project context (" + IProjectContext.class.getSimpleName() + ")");
            }
            IProjectContext projectContext = (IProjectContext)contexts.get(IProjectContext.class);
            projectContext.addProjectObserver(new IProjectObserver(){

                public void onProjectOpen(String projectId) {
                }

                public void onProjectClose(String projectId) {
                    RunnerApplication.this.finishApplication();
                }
            });
        }
        return new RunnerEnvironment(contexts, charset);
    }

    private static synchronized String generateInstanceId(String id) {
        return id + "_" + ++instanceCounter;
    }

    public boolean canEndApplication() {
        return this.application.canEndApplication();
    }

    public boolean finishApplication() {
        if (!this.canEndApplication()) {
            return false;
        }
        this.killApplication();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killApplication() {
        try {
            this.application.onApplicationEnd();
        }
        catch (ApplicationException e) {
            CSDKLogger logger = CSDKLogger.getInstance();
            String msg = "The finalization of the application generated an error.";
            logger.logSevere(msg, new Object[0]);
            logger.logException((Exception)((Object)e));
        }
        finally {
            this.runnerEnv.cleanupContexts();
        }
    }

    public void onAsyncMessageReceived(IMessage message, IMessageSender sender) {
        this.application.onAsyncMessageReceived(message, sender);
    }

    public Object onSyncMessageReceived(IMessage message, IMessageSender sender) {
        return this.application.onSyncMessageReceived(message, sender);
    }

    public void onApplicationEnd() throws ApplicationException {
        this.killApplication();
    }

    public void onApplicationStart() throws ApplicationException {
        this.application.onApplicationStart();
    }

    public String getInstanceId() {
        IApplicationContext context = this.runnerEnv.getContext(IApplicationContext.class);
        return context.getInstanceId();
    }

    public String getApplicationId() {
        IApplicationContext context = this.runnerEnv.getContext(IApplicationContext.class);
        return context.getApplicationId();
    }

    public IApplication getApplication() {
        return this.application;
    }
}

