/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner.application.manager;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.IMessageSender;
import csdk.v2.api.application.manager.IApplicationManagerContext;
import csdk.v2.helper.application.MessageSender;
import csdk.v2.runner.ApplicationManager;
import csdk.v2.runner.application.RunnerApplication;
import csdk.v2.runner.core.AbstractContext;

public class ApplicationManagerContext
extends AbstractContext
implements IApplicationManagerContext {
    private String applicationId;
    private String instanceId;

    public ApplicationManagerContext(String applicationId, String instanceId) {
        this.applicationId = applicationId;
        this.instanceId = instanceId;
    }

    public String runApplication(String appId) throws ApplicationException {
        ApplicationManager appManager = ApplicationManager.getInstance();
        RunnerApplication app = appManager.runApplication(appId);
        if (app == null) {
            return null;
        }
        return app.getInstanceId();
    }

    public boolean isApplicationRunning(String instanceId) {
        ApplicationManager appManager = ApplicationManager.getInstance();
        return appManager.isApplicationRunning(instanceId);
    }

    public void killApplication(String instanceId) throws ApplicationException {
        ApplicationManager appManager = ApplicationManager.getInstance();
        appManager.finishApplication(instanceId);
    }

    public Object sendSyncMessage(String appId, IMessage message) throws ApplicationException {
        ApplicationManager appManager = ApplicationManager.getInstance();
        MessageSender sender = new MessageSender(this.applicationId, this.instanceId);
        return appManager.sendSyncMessage(appId, message, (IMessageSender)sender);
    }

    public void sendAsyncMessage(String appId, IMessage message) throws ApplicationException {
        ApplicationManager appManager = ApplicationManager.getInstance();
        MessageSender sender = new MessageSender(this.applicationId, this.instanceId);
        appManager.sendAsyncMessage(appId, message, (IMessageSender)sender);
    }

    public void broadcastAsyncMessage(IMessage message) throws ApplicationException {
        ApplicationManager appManager = ApplicationManager.getInstance();
        MessageSender sender = new MessageSender(this.applicationId, this.instanceId);
        appManager.broadcastAsyncMessage(message, (IMessageSender)sender);
    }
}

