/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner.filesystem;

import csdk.v2.api.filesystem.FileLocationType;
import csdk.v2.api.filesystem.FileLockedException;
import csdk.v2.api.filesystem.IFile;
import csdk.v2.api.filesystem.IFileLock;
import csdk.v2.runner.filesystem.CSDKLocalFileLock;
import csdk.v2.runner.filesystem.FileType;
import csdk.v2.runner.filesystem.FileTypes;
import csdk.v2.runner.filesystem.FileUtils;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class RunnerFile
implements IFile {
    private final File file;
    private RandomAccessFile randomFile;
    private String type;

    private static String getFileExtension(String path) {
        if (path == null) {
            String msg = "Internal error: null path not allowed.";
            throw new IllegalArgumentException(msg);
        }
        if (path.trim().equals("")) {
            String msg = "Internal error: empty path not allowed.";
            throw new IllegalArgumentException(msg);
        }
        int periodIndex = path.lastIndexOf(".");
        if (periodIndex == -1 || periodIndex == path.length() - 1) {
            return null;
        }
        return path.substring(periodIndex + 1).toLowerCase();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        if (this.type == null) {
            String path = this.getAbsolutePath();
            String ext = RunnerFile.getFileExtension(path);
            if (ext == null) {
                return "UNKNOWN";
            }
            return RunnerFile.getTypeFromExtension(ext);
        }
        return this.type;
    }

    private static String getTypeFromExtension(String extension) {
        FileType fileType = FileTypes.getFileTypeFromExtension(extension);
        if (fileType == null) {
            return "UNKNOWN";
        }
        return fileType.getName();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public long position() throws IOException {
        return this.randomFile.getFilePointer();
    }

    public void position(long newPosition) throws IOException {
        this.randomFile.seek(newPosition);
    }

    public void close(boolean forceQuit) throws IOException {
        if (this.randomFile != null) {
            RandomAccessFile raf = this.randomFile;
            if (forceQuit) {
                this.randomFile = null;
            }
            raf.close();
            this.randomFile = null;
        }
    }

    public void close() throws IOException {
        this.close(true);
    }

    public long size() {
        return this.file.length();
    }

    public RunnerFile(File file) {
        this.file = file;
        this.randomFile = null;
    }

    public RunnerFile(File file, String fileType) {
        this.file = file;
        this.randomFile = null;
        this.type = fileType;
    }

    public IFile[] getChildren() {
        if (!this.file.isDirectory()) {
            return null;
        }
        ArrayList<RunnerFile> list = new ArrayList<RunnerFile>();
        for (File f : this.file.listFiles()) {
            list.add(new RunnerFile(f));
        }
        return list.toArray(new RunnerFile[list.size()]);
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public String getName() {
        return this.file.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    public String[] getPath() {
        return FileUtils.splitPath(this.file.getPath());
    }

    public String getStringPath() {
        return this.file.getAbsolutePath();
    }

    public void open(boolean readOnly) throws Exception {
        if (this.file.isDirectory()) {
            throw new Exception("Directory cannot be opened!");
        }
        String mode = readOnly ? "r" : "rws";
        this.randomFile = new RandomAccessFile(this.file, mode);
    }

    public long getModificationDate() {
        return this.file.lastModified();
    }

    public int read(byte[] dst, int off, int len, long position) throws Exception {
        this.randomFile.seek(position);
        int nRead = this.randomFile.read(dst, off, len);
        return nRead;
    }

    public int read(byte[] dst, long position) throws Exception {
        this.randomFile.seek(position);
        int nRead = this.randomFile.read(dst);
        return nRead;
    }

    public void write(byte[] src, int off, int len, long position) throws IOException, FileLockedException {
        this.randomFile.seek(position);
        this.randomFile.write(src, off, len);
    }

    public void write(byte[] src, long position) throws IOException, FileLockedException {
        this.randomFile.seek(position);
        this.randomFile.write(src);
    }

    public FileLocationType getFileLocationType() {
        return FileLocationType.LOCAL;
    }

    public IFile getParent() {
        return new RunnerFile(this.file.getParentFile());
    }

    public boolean exists() throws IOException {
        return this.file.exists();
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public boolean canExecute() {
        return this.file.canExecute();
    }

    public IFileLock acquireExclusiveLock(Window window) throws Exception {
        return new CSDKLocalFileLock(this.file, false, window);
    }

    public IFileLock acquireSharedLock(Window window) throws Exception {
        return new CSDKLocalFileLock(this.file, true, window);
    }
}

