/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner.rest;

import csdk.v2.runner.CSDKLogger;
import csdk.v2.runner.rest.DebugMapper;
import csdk.v2.runner.rest.ReloadFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Configuration;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;

public class RestController {
    private static RestController instance;
    private ResourceConfig resourceConfig;
    private HttpServer httpServer;
    private Container container;
    private final List<String> resourcePackages = new ArrayList<String>();
    private final Map<String, Set<Object>> instancesByAppId;
    private final Map<Class<?>, String> appIdsByResourceClass;
    private boolean shouldReload;
    private int httpPort;
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 15000;

    public static RestController getInstance() {
        if (instance == null) {
            instance = new RestController();
        }
        return instance;
    }

    private static int getAvailablePort() {
        int port;
        block11: {
            ServerSocket socket = null;
            port = -1;
            try {
                socket = new ServerSocket(0);
                port = socket.getLocalPort();
            }
            catch (IOException e) {
                if (socket == null) break block11;
                try {
                    socket.close();
                }
                catch (IOException e2) {
                    throw new RuntimeException("You should handle this error.", e2);
                }
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("You should handle this error.", e);
                    }
                }
            }
        }
        return port;
    }

    private RestController() {
        this.resourcePackages.add("csbase.client.rest.resources");
        this.instancesByAppId = new HashMap<String, Set<Object>>();
        this.appIdsByResourceClass = new HashMap();
    }

    public void stopServer() {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            this.httpServer.shutdownNow();
        }
    }

    public void startServer() {
        try {
            this.startServer(DEFAULT_HOST, 15000);
        }
        catch (ProcessingException ex) {
            this.startServer(DEFAULT_HOST, RestController.getAvailablePort());
        }
    }

    public void startServer(int port) {
        this.startServer(DEFAULT_HOST, port);
    }

    public void startServer(String host, int port) {
        this.httpPort = port;
        try {
            this.resourceConfig = this.buildResourceConfig();
            this.resourceConfig.registerInstances(new Object[]{new ContainerLifecycleListener(){

                public void onStartup(Container cont) {
                    RestController.this.container = cont;
                }

                public void onReload(Container cont) {
                }

                public void onShutdown(Container cont) {
                }
            }});
            String baseURL = "http://" + host + ":" + port + "/";
            this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)URI.create(baseURL), (ResourceConfig)this.resourceConfig);
            CSDKLogger logger = CSDKLogger.getInstance();
            logger.log("REST Server started at {0}", baseURL);
        }
        catch (Exception ex) {
            CSDKLogger logger = CSDKLogger.getInstance();
            logger.logException(ex);
        }
    }

    public void registerService(Class<?>[] classes) {
        this.resourceConfig.registerClasses((Class[])classes);
    }

    public void addResourcePackages(String ... packages) {
        this.resourcePackages.addAll(Arrays.asList(packages));
        if (this.container != null) {
            this.resourceConfig = this.buildResourceConfig();
            this.container.reload(this.resourceConfig);
        }
    }

    public void addApplicationResources(String appId, ResourceConfig config) {
        Set instances = config.getInstances();
        CSDKLogger logger = CSDKLogger.getInstance();
        for (Object i : instances) {
            this.appIdsByResourceClass.put(i.getClass(), appId);
            logger.log("Registering REST resource {0}", i.getClass());
        }
        this.instancesByAppId.put(appId, instances);
        this.shouldReload = true;
        this.reloadContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadContainer() {
        ReloadFilter.RequestCounter counter = ReloadFilter.getCounter();
        Object object = counter.getLock();
        synchronized (object) {
            if (this.shouldReload) {
                if (counter.isZero()) {
                    if (this.container != null) {
                        this.resourceConfig = this.buildResourceConfig();
                        this.container.reload(this.resourceConfig);
                    }
                    this.shouldReload = false;
                } else {
                    TimerTask timerTask = new TimerTask(){

                        @Override
                        public void run() {
                            RestController.this.reloadContainer();
                        }
                    };
                    Timer timer = new Timer("RestController reload timer");
                    timer.schedule(timerTask, 300L);
                }
            }
        }
    }

    public void removeApplicationResources(String appId) {
        this.instancesByAppId.remove(appId);
        this.appIdsByResourceClass.entrySet().removeIf(entry -> ((String)entry.getValue()).equals(appId));
        this.shouldReload = true;
        this.reloadContainer();
    }

    public int getPort() {
        if (this.httpServer == null || !this.httpServer.isStarted()) {
            return -999;
        }
        return this.httpPort;
    }

    public void registerPackages(String ... packages) {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            this.httpServer.shutdownNow();
        }
        this.resourcePackages.addAll(Arrays.asList(packages));
        this.startServer();
    }

    private ResourceConfig buildResourceConfig() {
        ResourceConfig rc = new ResourceConfig();
        rc.register(ApplicationApiModelProcessor.class);
        rc.packages(true, this.resourcePackages.toArray(new String[this.resourcePackages.size()]));
        this.instancesByAppId.entrySet().forEach(e -> rc.registerInstances(((Set)e.getValue()).toArray()));
        rc.register(JacksonFeature.class);
        rc.register(DebugMapper.class);
        rc.register(ReloadFilter.class);
        return rc;
    }

    public static class ApplicationApiModelProcessor
    implements ModelProcessor {
        public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
            ResourceModel.Builder newModelBuilder = new ResourceModel.Builder(false);
            for (Resource res : resourceModel.getResources()) {
                boolean isAppResource = false;
                for (Map.Entry prefixByClass : RestController.getInstance().appIdsByResourceClass.entrySet()) {
                    if (!res.getHandlerClasses().contains(prefixByClass.getKey())) continue;
                    isAppResource = true;
                    Resource newRes = this.createResource(res, (String)prefixByClass.getValue(), (Class)prefixByClass.getKey(), true);
                    newModelBuilder.addResource(newRes);
                }
                if (isAppResource) continue;
                newModelBuilder.addResource(res);
            }
            return newModelBuilder.build();
        }

        private Resource createResource(Resource resource, String appId, Class<?> clazz, boolean isParentResource) {
            Resource.Builder resourceBuilder = Resource.builder().name(resource.getName());
            if (isParentResource) {
                resourceBuilder.path("/" + appId + resource.getPath());
            } else {
                resourceBuilder.path(resource.getPath());
            }
            resource.getChildResources().forEach(r -> resourceBuilder.addChildResource(this.createResource((Resource)r, appId, clazz, false)));
            for (ResourceMethod resourceMethod : resource.getResourceMethods()) {
                Method classMethod = this.getClassMethod(resourceMethod);
                if (!classMethod.getDeclaringClass().equals(clazz)) continue;
                resourceBuilder.addMethod(resourceMethod);
            }
            return resourceBuilder.build();
        }

        private Method getClassMethod(ResourceMethod resourceMethod) {
            return resourceMethod.getInvocable().getDefinitionMethod();
        }

        public ResourceModel processSubResource(ResourceModel resourceModel, Configuration configuration) {
            return resourceModel;
        }
    }
}

