package csdk.v2.runner.filesystem;

import java.text.MessageFormat;
import java.util.ArrayList;

import csdk.v2.runner.Runner;

/**
 * Representa um tipo de arquivo associado  aplicao.
 *
 * Essa classe *no* deve ser usada por desenvolvedores CSDK em suas aplicaes.
 * Ela  de uso exclusivo do ambiente simulado do {@link Runner}.
 */
public class FileType {

  /**
   * O tipo
   */
  private final String name;

  /**
   * As extenses padronizadas
   */
  private final ArrayList<String> extensions = new ArrayList<>();

  /**
   * Consulta as extenses do tipo;
   *
   * @return extensions
   */
  public ArrayList<String> getExtensions() {
    return extensions;
  }

  /**
   * Adiciona uma extenso ao tipo
   *
   * @param extension a extenso.
   */
  public void addExtension(String extension) {
    FileType type = FileTypes.getFileTypeFromExtension(extension);
    if (type != null) {
      String pattern = "Extension {0} is already assigned to type: {1}";
      String err = MessageFormat.format(pattern, extension, type);
      throw new IllegalArgumentException(err);
    }
    extensions.add(extension);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return getName();
  }

  /**
   * Consulta do nome do tipo
   *
   * @return o nome.
   */
  public String getName() {
    return name;
  }

  /**
   * Construtor
   *
   * @param type o tipo
   */
  public FileType(String type) {
    if (type == null) {
      throw new IllegalArgumentException("Internal error: Type cannot be null.");
    }
    this.name = type.trim().toUpperCase();
  }
}
