package hello;

import java.net.URL;
import java.util.ResourceBundle;

import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import tecgraf.javautils.gui.SwingThreadDispatcher;

/**
 * Controle da Aplicao Hello JavaFX.
 *
 * @author Tecgraf/PUC-Rio
 */
public class ControleAplicacao implements Initializable {

  @FXML
  Label lblMensagem;

  @FXML
  TextField txtNome;

  /**
   * Referencia para aplicao JavaFX associada
   */
  private FXHello application;

  /**
   * Construtor.
   * 
   * @param application referencia para aplicao JavaFX associada
   */
  public ControleAplicacao(FXHello application) {
    this.application = application;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void initialize(URL url, ResourceBundle resourceBundle) {
  }

  /**
   * Ao executada pelo boto Click.
   */
  public void atualizaMensagem() {
    lblMensagem.setText("Ol " + txtNome.getText() + ", bem vindo!");
  }

  /**
   * Ao executada pelo boto Fechar.
   */
  public void fechar() {
    SwingThreadDispatcher.invokeLater(new Runnable() {
      @Override
      public void run() {
        application.finishApplication();
      }
    });
  }

}