/*
 * Decompiled with CFR 0.152.
 */
package snakegame.session;

import java.util.ArrayList;
import java.util.List;
import snakegame.algorithm.IMoveAlgorithm;
import snakegame.session.Level;
import snakegame.session.MapSize;
import snakegame.session.Mode;
import snakegame.session.listener.MapSizeChangedListener;
import snakegame.session.listener.ModeChangedListener;

public class Session {
    private MapSize mapSize;
    private Mode mode;
    private Level level;
    private IMoveAlgorithm algorithm;
    private List<ModeChangedListener> modeChangedListeners;
    private List<MapSizeChangedListener> mapSizeChangedListeners;

    public Session(MapSize mapSize, Level level) {
        if (mapSize == null) {
            throw new IllegalArgumentException("mapSize n\u00e3o pode ser nulo.");
        }
        if (level == null) {
            throw new IllegalArgumentException("level n\u00e3o pode ser nulo.");
        }
        this.mapSize = mapSize;
        this.level = level;
        this.mode = Mode.OFF;
        this.modeChangedListeners = new ArrayList<ModeChangedListener>();
        this.mapSizeChangedListeners = new ArrayList<MapSizeChangedListener>();
    }

    public MapSize getMapSize() {
        return this.mapSize;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Level getLevel() {
        return this.level;
    }

    public IMoveAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setMapSize(MapSize mapSize) {
        if (mapSize == null) {
            throw new IllegalArgumentException("mapSize n\u00e3o pode ser nulo.");
        }
        this.mapSize = mapSize;
        for (MapSizeChangedListener listener : this.mapSizeChangedListeners) {
            listener.perform(mapSize);
        }
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode n\u00e3o pode ser nulo.");
        }
        this.mode = mode;
        for (ModeChangedListener listener : this.modeChangedListeners) {
            switch (mode) {
                case ON: {
                    listener.modeOn(this.algorithm);
                    break;
                }
                case OFF: {
                    listener.modeOff();
                }
            }
        }
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new IllegalArgumentException("level n\u00e3o pode ser nulo.");
        }
        this.level = level;
    }

    public void setAlgorithm(IMoveAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void addMapSizeChangedListener(MapSizeChangedListener listener) {
        this.mapSizeChangedListeners.add(listener);
    }

    public void addModeChangedListener(ModeChangedListener listener) {
        this.modeChangedListeners.add(listener);
    }
}

