/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.core.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class IOUtils {
    public static long transferTo(FileChannel srcChannel, long position, long count, WritableByteChannel dstChannel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        return IOUtils.transferTo(srcChannel, position, count, dstChannel, buffer);
    }

    public static long transferTo(FileChannel srcChannel, long position, long count, WritableByteChannel dstChannel, ByteBuffer buffer) throws IOException {
        if (srcChannel == null) {
            throw new IllegalArgumentException("srcChannel == null");
        }
        if (position < 0L) {
            throw new IllegalArgumentException("position < 0");
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count < 0");
        }
        if (dstChannel == null) {
            throw new IllegalArgumentException("dstChannel == null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("nioBuffer == null");
        }
        long countRemaining = count;
        long totalBytesWritten = 0L;
        long positionBackup = srcChannel.position();
        srcChannel.position(position);
        while (countRemaining > 0L) {
            int bytesRead;
            buffer.clear();
            if ((long)buffer.remaining() > countRemaining) {
                buffer.limit((int)countRemaining);
            }
            if ((bytesRead = srcChannel.read(buffer)) == -1) {
                srcChannel.position(positionBackup);
                return totalBytesWritten;
            }
            buffer.flip();
            int bytesWritten = dstChannel.write(buffer);
            if (bytesWritten == -1) {
                srcChannel.position(positionBackup);
                return totalBytesWritten;
            }
            countRemaining -= (long)bytesWritten;
            totalBytesWritten += (long)bytesWritten;
            if (!buffer.hasRemaining()) continue;
            srcChannel.position(positionBackup);
            return totalBytesWritten;
        }
        srcChannel.position(positionBackup);
        return totalBytesWritten;
    }
}

