/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.field;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import tecgraf.javautils.gui.field.CompleteText;

public abstract class RegexDocument
extends PlainDocument {
    private String regex;
    private CompleteText completeText;

    public RegexDocument(String regex) {
        this(regex, null);
    }

    public RegexDocument(String regex, CompleteText completeText) {
        this.regex = regex;
        this.completeText = completeText;
    }

    protected void fireAllListeners(Object oldValue, Object newValue, boolean valueIsAdjusting) {
    }

    protected abstract Object getValue();

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        boolean valueIsAdjusting = true;
        if (this.getCurrentWriter() == null) {
            valueIsAdjusting = false;
        }
        Object oldValue = this.getValue();
        super.remove(offs, len);
        Object newValue = this.getValue();
        this.fireAllListeners(oldValue, newValue, valueIsAdjusting);
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String newText = null;
        if (this.getLength() > 0) {
            String text = this.getText(0, this.getLength());
            if (this.getCompleteText() != null && offs == this.getLength()) {
                str = this.getCompleteText().buildCompletedText(text, str);
            }
            newText = text.substring(0, offs) + str + text.substring(offs, this.getLength());
        } else {
            if (this.getCompleteText() != null && offs == this.getLength()) {
                str = this.getCompleteText().buildCompletedText("", str);
            }
            newText = str;
        }
        if (newText.matches(this.regex)) {
            Object oldValue = this.getValue();
            super.insertString(offs, str, a);
            Object newValue = this.getValue();
            this.fireAllListeners(oldValue, newValue, false);
        }
    }

    public CompleteText getCompleteText() {
        return this.completeText;
    }

    public void setCompleteText(CompleteText completeText) {
        this.completeText = completeText;
    }
}

