/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CSDKLogger {
    private static final Level DEFAULT_LOGGER_LEVEL = Level.SEVERE;
    private final Logger logger = Logger.getLogger("global");
    private static CSDKLogger instance;

    private CSDKLogger() {
        this.setVerbosed(false);
        CSDKLoggerFormatter formatter = new CSDKLoggerFormatter();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(formatter);
        this.logger.addHandler(handler);
        this.logger.setUseParentHandlers(false);
    }

    public static CSDKLogger getInstance() {
        if (instance == null) {
            instance = new CSDKLogger();
        }
        return instance;
    }

    public void setVerbosed(boolean verbosed) {
        Level level = verbosed ? Level.ALL : DEFAULT_LOGGER_LEVEL;
        this.logger.setLevel(level);
    }

    public void log(String text, Object ... args) {
        String message = MessageFormat.format(text, args);
        this.logger.log(Level.INFO, message);
    }

    public void logSevere(String text, Object ... args) {
        String message = MessageFormat.format(text, args);
        this.logger.log(Level.SEVERE, message);
    }

    public void logException(Exception e) {
        String exceptionDetails = this.extractErrorInfo(e);
        this.logSevere(exceptionDetails, new Object[0]);
        Throwable cause = e.getCause();
        if (cause != null) {
            this.logSevere("Caused by:", new Object[0]);
            String causeInfo = this.extractErrorInfo(cause);
            this.logSevere(causeInfo, new Object[0]);
        }
    }

    private String extractErrorInfo(Throwable e) {
        StringWriter sw = new StringWriter();
        String message = e.getMessage();
        if (message != null) {
            sw.append("Exception message: ");
            sw.append(message);
            sw.append("\n");
        }
        e.printStackTrace(new PrintWriter(sw));
        String exceptionDetails = sw.toString();
        return exceptionDetails;
    }

    private static final class CSDKLoggerFormatter
    extends Formatter {
        private final Date date = new Date();

        private CSDKLoggerFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder b = new StringBuilder();
            this.date.setTime(record.getMillis());
            b.append(this.date);
            b.append(" [CSDK] ");
            b.append(record.getMessage());
            b.append(System.getProperty("line.separator"));
            return b.toString();
        }
    }
}

