/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.awt.Color;
import javax.swing.ImageIcon;

public class Colored<T extends Comparable<T>>
implements Comparable<Colored<T>> {
    private static final Color STANDARD_COLOR = Color.BLACK;
    private T value;
    private Color color;
    private ImageIcon icon;
    private IconAlignment iconAlign = IconAlignment.LEFT;
    private String tooltipText;
    private boolean showValue;

    public Colored(Color color) {
        this(null, color);
    }

    public Colored(T value) {
        this(value, STANDARD_COLOR);
    }

    public Colored(T value, Color color) {
        this(value, color, null);
    }

    public Colored(T value, Color color, ImageIcon icon) {
        this(value, color, icon, true);
    }

    public Colored(T value, Color color, ImageIcon icon, boolean showText) {
        this.set(value, color, icon);
        this.showValue = showText;
    }

    public void set(T value, Color color) {
        this.set(value);
        this.color = color;
    }

    public void set(T value) {
        this.value = value;
    }

    public void set(T value, Color color, ImageIcon icon) {
        this.set(value, color);
        this.icon = icon;
    }

    public void setIconAlignment(IconAlignment side) {
        this.iconAlign = side;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Colored<T> o) {
        if (o != null && this.value != null && o.value != null) {
            return this.value.compareTo(o.value);
        }
        if (o == null || o.value == null) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o == null || !Colored.class.isInstance(o)) {
            return false;
        }
        Colored other = (Colored)Colored.class.cast(o);
        if (this.value == null && other.value == null) {
            return true;
        }
        if (this.value == null && other.value != null || !this.value.equals(other.value)) {
            return false;
        }
        return (this.color != null || other.color == null) && this.color.equals(other.color);
    }

    public Color getColor() {
        return this.color;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public IconAlignment getIconAlignment() {
        return this.iconAlign;
    }

    public String getToolTipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public boolean showValue() {
        return this.showValue;
    }

    public static enum IconAlignment {
        LEFT,
        RIGHT;

    }
}

