package textviewer.actions.core;

import java.awt.Window;
import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;

import textviewer.TextViewer;
import csdk.v2.api.filesystem.IFile;
import csdk.v2.helper.application.AbstractApplicationAction;

/**
 * Ao de abertura do arquivo
 * 
 * @author Tecgraf/PUC-Rio
 */
abstract public class OpenAction extends AbstractApplicationAction<TextViewer> {

  /**
   * Busca o arquivo
   * 
   * @return o arquivo
   * @throws Exception em caso de erro.
   */
  abstract protected IFile selectFile() throws Exception;

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent ae) {
    final TextViewer textViewer = getApplication();
    Window frm = textViewer.getApplicationFrame();
    try {
      final IFile file = selectFile();
      if (file == null) {
        return;
      }
      textViewer.openFile(file);
    }
    catch (Exception e) {
      JOptionPane.showMessageDialog(frm, e, textViewer.getApplicationName(),
        JOptionPane.ERROR_MESSAGE);
    }
  }

  /**
   * Construtor
   * 
   * @param textViewer a aplicao.
   */
  public OpenAction(TextViewer textViewer) {
    super(textViewer);

  }
}
