/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.field;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.text.BadLocationException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.field.CompleteText;
import tecgraf.javautils.gui.field.DateEvent;
import tecgraf.javautils.gui.field.DateListener;
import tecgraf.javautils.gui.field.RegexDocument;

public class DateDocument
extends RegexDocument {
    private static String sep = "/";
    private Format format;
    private Locale locale;

    public DateDocument() {
        this((Locale)null);
    }

    public DateDocument(Locale locale) {
        super(DateDocument.getRegex(DateDocument.getFormat(locale)), DateDocument.buildAutoComplete(DateDocument.getFormat(locale)));
        this.setLocale(locale);
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = LNG.getLocale();
        }
        this.locale = locale;
        this.format = DateDocument.getFormat(locale);
    }

    private static Format getFormat(Locale locale) {
        if (locale == null) {
            locale = LNG.getLocale();
        }
        if (locale.toString().equals("es_AR")) {
            return Format.DDMMYYYY;
        }
        if (locale.toString().equals("en_US")) {
            return Format.MMDDYYYY;
        }
        return Format.DDMMYYYY;
    }

    private static String getRegex(Format format) {
        String year = "([0-9]{1,4})?";
        String daymonth = "([0-9]{1,2})?";
        String sep = "(/)?";
        String regex = "";
        if (format == Format.MMDDYYYY || format == Format.DDMMYYYY) {
            regex = daymonth + sep + daymonth + sep + year;
        }
        return regex;
    }

    public boolean isValid() {
        return this.getDate() != null;
    }

    private static boolean validateDateWithRegex(String date, Format format) {
        String daymonth = "[0-9]{1,2}";
        String year = "[0-9]{4}";
        String regex = "";
        if (format == Format.MMDDYYYY || format == Format.DDMMYYYY) {
            regex = daymonth + sep + daymonth + sep + year;
        }
        return date != null && date.matches(regex);
    }

    public static boolean validateDateFormat(String date, Locale locale) {
        Format format = DateDocument.getFormat(locale);
        return DateDocument.validateDateWithRegex(date, format);
    }

    public static Date getDate(String date, Locale locale) {
        Format format = DateDocument.getFormat(locale);
        if (DateDocument.validateDateWithRegex(date, format)) {
            int year = 0;
            int month = 0;
            int day = 0;
            String[] split = date.split("/");
            if (format == Format.DDMMYYYY) {
                day = Integer.parseInt(split[0]);
                month = Integer.parseInt(split[1]);
                year = Integer.parseInt(split[2]);
            } else if (format == Format.MMDDYYYY) {
                month = Integer.parseInt(split[0]);
                day = Integer.parseInt(split[1]);
                year = Integer.parseInt(split[2]);
            }
            try {
                GregorianCalendar gc = new GregorianCalendar();
                gc.setLenient(false);
                gc.clear();
                gc.set(5, day);
                gc.set(2, month - 1);
                gc.set(1, year);
                return gc.getTime();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private GregorianCalendar getGregorianCalendar() {
        Long date = this.getDate();
        if (date != null) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(date);
            return gc;
        }
        return null;
    }

    public Integer getDay() {
        GregorianCalendar gc = this.getGregorianCalendar();
        if (gc != null) {
            return gc.get(5);
        }
        return null;
    }

    public Integer getMonth() {
        GregorianCalendar gc = this.getGregorianCalendar();
        if (gc != null) {
            return gc.get(2) + 1;
        }
        return null;
    }

    public Integer getYear() {
        GregorianCalendar gc = this.getGregorianCalendar();
        if (gc != null) {
            return gc.get(1);
        }
        return null;
    }

    public Long getDate() {
        try {
            String text = this.getText(0, this.getLength());
            Date date = DateDocument.getDate(text, this.locale);
            if (date != null) {
                return date.getTime();
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setDate(int day, int month, int year) {
        try {
            this.replace(0, this.getLength(), DateDocument.toString(this.format, day, month, year), null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setDate(long lngDate) {
        try {
            this.replace(0, this.getLength(), DateDocument.toString(this.locale, lngDate), null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setToCurrentDate() {
        this.setDate(System.currentTimeMillis());
    }

    private static CompleteText buildAutoComplete(final Format format) {
        if (format != null) {
            return new CompleteText(){

                @Override
                public String buildCompletedText(String text, String newStr) {
                    String regex1 = "";
                    String regex2 = "";
                    String complt1 = "";
                    String complt2 = "";
                    if (format == Format.DDMMYYYY || format == Format.MMDDYYYY) {
                        regex1 = "[0-9]{2}";
                        regex2 = "[0-9]{2}" + sep + "[0-9]{2}";
                        complt1 = "[0-9]{1,2}(" + sep + "([0-9]{1,4})?)?";
                        complt2 = "[0-9]{1,4}";
                    }
                    if (text.matches(regex1) && newStr.matches(complt1) || text.matches(regex2) && newStr.matches(complt2)) {
                        return sep + newStr;
                    }
                    return newStr;
                }
            };
        }
        return null;
    }

    public static String toString(Locale locale, long date) {
        Format format = DateDocument.getFormat(locale);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        return DateDocument.toString(format, day, month, year);
    }

    public static String toString(Format format, int day, int month, int year) {
        String strDate = "";
        if (day > 0 && month > 0 && year > 0) {
            if (format == Format.DDMMYYYY) {
                strDate = DateDocument.getNumberStr(day) + sep + DateDocument.getNumberStr(month) + sep + DateDocument.getNumberStr(year);
            } else if (format == Format.MMDDYYYY) {
                strDate = DateDocument.getNumberStr(month) + sep + DateDocument.getNumberStr(day) + sep + DateDocument.getNumberStr(year);
            }
        }
        return strDate;
    }

    private static String getNumberStr(int value) {
        if (value >= 0 && value <= 9) {
            return "0" + value;
        }
        return Integer.toString(value);
    }

    protected void rebuildCompleText() {
        this.setCompleteText(DateDocument.buildAutoComplete(DateDocument.getFormat(this.locale)));
    }

    @Override
    protected Object getValue() {
        return this.getDate();
    }

    protected Format getFormat() {
        return this.format;
    }

    @Override
    protected void fireAllListeners(Object oldValue, Object newValue, boolean valueIsAdjusting) {
        DateListener[] listeners;
        boolean monthChanged = false;
        Long oldDate = (Long)oldValue;
        Long newDate = (Long)newValue;
        if (oldValue != null && newValue != null) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(oldDate);
            int actualMonth = gc.get(2);
            int actualYear = gc.get(1);
            gc.setTimeInMillis(newDate);
            boolean dateInSameMonth = gc.get(2) == actualMonth;
            boolean dateInSameYear = gc.get(1) == actualYear;
            monthChanged = dateInSameMonth && dateInSameYear;
        }
        DateEvent event = new DateEvent(newDate, monthChanged, valueIsAdjusting);
        for (DateListener listener : listeners = (DateListener[])this.listenerList.getListeners(DateListener.class)) {
            listener.dateUpdated(event);
        }
    }

    public void addDateListener(DateListener listener) {
        this.listenerList.add(DateListener.class, listener);
    }

    public void removeDateListener(DateListener listener) {
        this.listenerList.remove(DateListener.class, listener);
    }

    public static enum Format {
        MMDDYYYY,
        DDMMYYYY;

    }
}

