/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public class GBC
extends GridBagConstraints {
    public GBC(int gridx, int gridy, int anchor, int fill, Insets insets) {
        super(gridx, gridy, 1, 1, 0.0, 0.0, anchor, fill, insets, 0, 0);
        this.fill(fill);
        this.insets(insets);
    }

    public GBC(int gridx, int gridy, Insets insets) {
        this(gridx, gridy, 10, 0, insets);
    }

    public GBC(int gridx, int gridy) {
        this(gridx, gridy, 10, 0, null);
    }

    public GBC() {
        this(0, 0);
    }

    public GBC(GBC other) {
        this(other.gridx, other.gridy, (Insets)other.insets.clone());
        this.anchor = other.anchor;
        this.fill = other.fill;
        this.gridwidth = other.gridwidth;
        this.gridheight = other.gridheight;
        this.weightx = other.weightx;
        this.weighty = other.weighty;
    }

    private GBC fill(int _fill) {
        this.fill = _fill;
        if ((this.fill == 2 || this.fill == 1) && this.weightx == 0.0) {
            this.weightx = 1.0;
        }
        if ((this.fill == 3 || this.fill == 1) && this.weighty == 0.0) {
            this.weighty = 1.0;
        }
        return this;
    }

    public GBC none() {
        return this.fill(0);
    }

    public GBC both() {
        return this.fill(1);
    }

    public GBC both(double wx, double wy) {
        if (wy < 0.0 || wx < 0.0) {
            throw new IllegalArgumentException("GBC: pesos devem ser maiores ou iguais a zero");
        }
        this.fill(1);
        this.weightx = wx;
        this.weighty = wy;
        return this;
    }

    public GBC vertical() {
        return this.fill(3);
    }

    public GBC vertical(double wy) {
        if (wy < 0.0) {
            throw new IllegalArgumentException("GBC: peso deve ser maior ou igual a zero");
        }
        this.fill(3);
        this.weighty = wy;
        return this;
    }

    public GBC horizontal() {
        return this.fill(2);
    }

    public GBC horizontal(double wx) {
        if (wx < 0.0) {
            throw new IllegalArgumentException("GBC: peso deve ser maior ou igual a zero");
        }
        this.fill(2);
        this.weightx = wx;
        return this;
    }

    private GBC anchor(int _anchor) {
        this.anchor = _anchor;
        return this;
    }

    public GBC center() {
        return this.anchor(10);
    }

    public GBC north() {
        return this.anchor(11);
    }

    public GBC northeast() {
        return this.anchor(12);
    }

    public GBC east() {
        return this.anchor(13);
    }

    public GBC southeast() {
        return this.anchor(14);
    }

    public GBC south() {
        return this.anchor(15);
    }

    public GBC southwest() {
        return this.anchor(16);
    }

    public GBC west() {
        return this.anchor(17);
    }

    public GBC northwest() {
        return this.anchor(18);
    }

    public GBC pushxy() {
        return this.pushxy(1.0, 1.0);
    }

    public GBC pushx() {
        return this.pushx(1.0);
    }

    public GBC pushy() {
        return this.pushy(1.0);
    }

    public GBC pushxy(double wx, double wy) {
        return this.none().weights(wx, wy);
    }

    public GBC pushx(double wx) {
        switch (this.fill) {
            case 1: {
                this.vertical();
                break;
            }
            case 2: {
                this.none();
            }
        }
        return this.weightx(wx);
    }

    public GBC pushy(double wy) {
        switch (this.fill) {
            case 1: {
                this.horizontal();
                break;
            }
            case 3: {
                this.none();
            }
        }
        return this.weighty(wy);
    }

    public GBC fillx() {
        switch (this.fill) {
            case 0: {
                return this.horizontal(0.0);
            }
            case 1: 
            case 2: {
                return this.weightx(0.0);
            }
            case 3: {
                return this.both(0.0, this.weighty);
            }
        }
        return this;
    }

    public GBC filly() {
        switch (this.fill) {
            case 0: {
                return this.vertical(0.0);
            }
            case 1: 
            case 3: {
                return this.weighty(0.0);
            }
            case 2: {
                return this.both(this.weightx, 0.0);
            }
        }
        return this;
    }

    public GBC fillxy() {
        return this.both(0.0, 0.0);
    }

    public GBC insets(Insets _insets) {
        this.insets = _insets == null ? new Insets(0, 0, 0, 0) : _insets;
        return this;
    }

    public GBC insets(int top, int left, int bottom, int right) {
        this.insets = new Insets(top, left, bottom, right);
        return this;
    }

    public GBC insets(int defaultValue) {
        this.insets = new Insets(defaultValue, defaultValue, defaultValue, defaultValue);
        return this;
    }

    public GBC top(int top) {
        this.insets.top = top;
        return this;
    }

    public GBC bottom(int bottom) {
        this.insets.bottom = bottom;
        return this;
    }

    public GBC right(int right) {
        this.insets.right = right;
        return this;
    }

    public GBC left(int left) {
        this.insets.left = left;
        return this;
    }

    public GBC weightx(double wx) {
        this.weightx = wx;
        return this;
    }

    public GBC weighty(double wy) {
        this.weighty = wy;
        return this;
    }

    public GBC weights(double wx, double wy) {
        this.weightx = wx;
        this.weighty = wy;
        return this;
    }

    public GBC width(int width) {
        this.gridwidth = width;
        return this;
    }

    public GBC height(int height) {
        this.gridheight = height;
        return this;
    }

    public GBC gridx(int gx) {
        this.gridx = gx;
        return this;
    }

    public GBC gridy(int gy) {
        this.gridy = gy;
        return this;
    }

    public GBC gridwidth(int gw) {
        this.gridwidth = gw;
        return this;
    }

    public GBC gridheight(int gh) {
        this.gridheight = gh;
        return this;
    }

    private static String getAnchorName(int value) {
        if (value == 12) {
            return "NORTHEAST";
        }
        if (value == 13) {
            return "EAST";
        }
        if (value == 14) {
            return "SOUTHEAST";
        }
        if (value == 15) {
            return "SOUTH";
        }
        if (value == 16) {
            return "SOUTHWEST";
        }
        if (value == 17) {
            return "WEST";
        }
        if (value == 18) {
            return "NORTHWEST";
        }
        if (value == 10) {
            return "CENTER";
        }
        return Integer.toString(value);
    }

    private static String getFillName(int value) {
        if (value == 0) {
            return "NONE";
        }
        if (value == 2) {
            return "HORIZONTAL";
        }
        if (value == 3) {
            return "VERTICAL";
        }
        if (value == 1) {
            return "BOTH";
        }
        if (value == 11) {
            return "NORTH";
        }
        return Integer.toString(value);
    }

    public String toString() {
        return String.format("[GBC] x=%d y=%d width=%d height=%d weightx=%.1f weighty=%.1f anchor=%s fill=%s insets=%s", this.gridx, this.gridy, this.gridwidth, this.gridheight, this.weightx, this.weighty, GBC.getAnchorName(this.anchor), GBC.getFillName(this.fill), this.insets.toString());
    }
}

